/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.RespStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;

public class DuplicateResponse
extends RespStructure {
    public byte[] encryptionKeyOut;
    public TPM2B_PRIVATE duplicate;
    public byte[] outSymSeed;

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedByteBuf(this.encryptionKeyOut);
        this.duplicate.toTpm(buf);
        buf.writeSizedByteBuf(this.outSymSeed);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.encryptionKeyOut = buf.readSizedByteBuf();
        this.duplicate = TPM2B_PRIVATE.fromTpm(buf);
        this.outSymSeed = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static DuplicateResponse fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(DuplicateResponse.class);
    }

    public static DuplicateResponse fromTpm(byte[] byteBuf) {
        return DuplicateResponse.fromBytes(byteBuf);
    }

    public static DuplicateResponse fromTpm(TpmBuffer buf) {
        return buf.createObj(DuplicateResponse.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("DuplicateResponse");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte[]", "encryptionKeyOut", this.encryptionKeyOut);
        _p.add(d, "TPM2B_PRIVATE", "duplicate", this.duplicate);
        _p.add(d, "byte[]", "outSymSeed", this.outSymSeed);
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

