/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.RespStructure;
import tss.SessEncInfo;
import tss.TpmBuffer;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_CREATION_DATA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_TK_CREATION;
import tss.tpm.TPM_HANDLE;

public class CreatePrimaryResponse
extends RespStructure {
    public TPM_HANDLE handle = new TPM_HANDLE();
    public TPMT_PUBLIC outPublic;
    public TPMS_CREATION_DATA creationData;
    public byte[] creationHash;
    public TPMT_TK_CREATION creationTicket;
    public byte[] name;

    @Override
    public void toTpm(TpmBuffer buf) {
        buf.writeSizedObj(this.outPublic);
        buf.writeSizedObj(this.creationData);
        buf.writeSizedByteBuf(this.creationHash);
        this.creationTicket.toTpm(buf);
        buf.writeSizedByteBuf(this.name);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.outPublic = buf.createSizedObj(TPMT_PUBLIC.class);
        this.creationData = buf.createSizedObj(TPMS_CREATION_DATA.class);
        this.creationHash = buf.readSizedByteBuf();
        this.creationTicket = TPMT_TK_CREATION.fromTpm(buf);
        this.name = buf.readSizedByteBuf();
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static CreatePrimaryResponse fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(CreatePrimaryResponse.class);
    }

    public static CreatePrimaryResponse fromTpm(byte[] byteBuf) {
        return CreatePrimaryResponse.fromBytes(byteBuf);
    }

    public static CreatePrimaryResponse fromTpm(TpmBuffer buf) {
        return buf.createObj(CreatePrimaryResponse.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("CreatePrimaryResponse");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "TPMT_PUBLIC", "outPublic", this.outPublic);
        _p.add(d, "TPMS_CREATION_DATA", "creationData", this.creationData);
        _p.add(d, "byte[]", "creationHash", this.creationHash);
        _p.add(d, "TPMT_TK_CREATION", "creationTicket", this.creationTicket);
        _p.add(d, "byte[]", "name", this.name);
    }

    @Override
    public int numHandles() {
        return 1;
    }

    @Override
    public TPM_HANDLE getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(TPM_HANDLE h) {
        this.handle = h;
    }

    @Override
    public SessEncInfo sessEncInfo() {
        return new SessEncInfo(2, 1);
    }
}

