/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.IOException;
import java.net.Socket;
import tss.Helpers;
import tss.TpmDevice;
import tss.TpmException;

public class TpmDeviceTcp
extends TpmDevice {
    protected Socket CommandSocket = null;
    protected Socket SignalSocket = null;
    String hostName;
    int port;
    boolean linuxTrm;
    boolean oldTrm = true;
    boolean responsePending;
    int currentLocality;

    public TpmDeviceTcp(String hostName, int port, boolean linuxTrm) {
        this.init(hostName, port, linuxTrm);
    }

    public TpmDeviceTcp(String hostName, int port) {
        this.init(hostName, port, false);
    }

    void init(String hostName, int port, boolean linuxTrm) {
        this.hostName = hostName;
        this.port = port;
        this.linuxTrm = linuxTrm;
    }

    @Override
    public boolean connect() {
        try {
            this.CommandSocket = new Socket(this.hostName, this.port);
            if (!this.linuxTrm) {
                this.SignalSocket = new Socket(this.hostName, this.port + 1);
            }
        }
        catch (Exception e) {
            if (this.CommandSocket != null) {
                try {
                    this.CommandSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.err.println("Failed to connect to the TPM at " + this.hostName + ":" + this.port + ": " + e.getMessage());
            return false;
        }
        if (this.linuxTrm) {
            byte[] byArray = new byte[12];
            byArray[0] = -128;
            byArray[1] = 1;
            byArray[5] = 12;
            byArray[8] = 1;
            byArray[9] = 123;
            byArray[11] = 8;
            byte[] cmdGetRandom = byArray;
            byte[] resp = null;
            try {
                this.dispatchCommand(cmdGetRandom);
                resp = this.getResponse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resp == null || resp.length != 20) {
                try {
                    this.CommandSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.CommandSocket = null;
                if (this.oldTrm) {
                    this.oldTrm = false;
                    this.connect(this.hostName, this.port);
                } else {
                    System.err.println("Unknown user mode TRM protocol version");
                    return false;
                }
            }
        }
        return true;
    }

    public void connect(String hostName, int port, boolean linuxTrm) {
        this.init(hostName, port, linuxTrm);
    }

    public void connect(String hostName, int port) {
        this.init(hostName, port, false);
    }

    @Override
    public void close() {
        if (this.CommandSocket != null) {
            this.writeInt(this.CommandSocket, TcpTpmCommands.SessionEnd.Val);
            try {
                this.CommandSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.CommandSocket = null;
        }
        if (this.SignalSocket != null) {
            this.writeInt(this.SignalSocket, TcpTpmCommands.SessionEnd.Val);
            try {
                this.SignalSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.SignalSocket = null;
        }
    }

    @Override
    public void dispatchCommand(byte[] commandBuffer) {
        this.writeInt(this.CommandSocket, TcpTpmCommands.SendCommand.Val);
        this.writeBuf(this.CommandSocket, new byte[]{(byte)this.currentLocality});
        if (this.linuxTrm && this.oldTrm) {
            this.writeBuf(this.CommandSocket, new byte[1]);
            this.writeBuf(this.CommandSocket, new byte[]{1});
        }
        this.writeInt(this.CommandSocket, commandBuffer.length);
        try {
            this.CommandSocket.getOutputStream().write(commandBuffer);
            this.responsePending = true;
        }
        catch (IOException e) {
            throw new TpmException("Error sending data to the TPM", e);
        }
    }

    @Override
    public byte[] getResponse() {
        if (!this.responsePending) {
            throw new TpmException("Cannot getResponse() without a prior dispatchCommand()");
        }
        this.responsePending = false;
        byte[] outBuf = this.readEncapsulated(this.CommandSocket);
        this.readInt(this.CommandSocket);
        return outBuf;
    }

    @Override
    public boolean responseReady() {
        int available;
        if (!this.responsePending) {
            throw new TpmException("Cannot responseReady() without a prior dispatchCommand()");
        }
        try {
            available = this.CommandSocket.getInputStream().available();
        }
        catch (IOException e) {
            throw new TpmException("Error getting data from the TPM", e);
        }
        return available > 0;
    }

    @Override
    public void powerCtl(boolean on) {
        this.sendCmdAndGetAck(this.SignalSocket, on ? TcpTpmCommands.SignalPowerOn : TcpTpmCommands.SignalPowerOff);
        this.sendCmdAndGetAck(this.SignalSocket, on ? TcpTpmCommands.SignalNvOn : TcpTpmCommands.SignalNvOff);
    }

    @Override
    public void assertPhysicalPresence(boolean on) {
        this.sendCmdAndGetAck(this.SignalSocket, on ? TcpTpmCommands.SignalPPOn : TcpTpmCommands.SignalPPOff);
    }

    @Override
    public void setLocality(int locality) {
        this.currentLocality = locality;
    }

    public void sendCmdAndGetAck(Socket s, TcpTpmCommands comm) {
        this.writeEncapsulated(s, Helpers.hostToNet(comm.getVal()));
        this.getAck(s);
    }

    private void getAck(Socket s) {
        this.readInt(s);
    }

    private int readInt(Socket s) {
        int val = -1;
        try {
            val = Helpers.netToHost(this.readBuf(s, 4));
        }
        catch (Exception e) {
            throw new TpmException("TPM IO error", e);
        }
        return val;
    }

    private void writeInt(Socket s, int val) {
        this.writeBuf(s, Helpers.hostToNet(val));
    }

    private void writeBuf(Socket s, byte[] buffer) {
        try {
            s.getOutputStream().write(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            throw new TpmException("TPM IO error", e);
        }
    }

    private byte[] readBuf(Socket s, int numBytes) {
        byte[] buf = new byte[numBytes];
        int numRead = 0;
        while (numRead < numBytes) {
            int sz;
            try {
                sz = s.getInputStream().read(buf, numRead, numBytes - numRead);
            }
            catch (IOException e) {
                throw new TpmException("TPM IO error", e);
            }
            numRead += sz;
        }
        return buf;
    }

    private void writeEncapsulated(Socket s, byte[] buf) {
        this.writeBuf(s, Helpers.hostToNet(buf.length));
        this.writeBuf(s, buf);
    }

    private byte[] readEncapsulated(Socket s) {
        byte[] t = this.readBuf(s, 4);
        int sz = Helpers.netToHost(t);
        return this.readBuf(s, sz);
    }

    static enum TcpTpmCommands {
        SignalPowerOn(1),
        SignalPowerOff(2),
        SignalPPOn(3),
        SignalPPOff(4),
        SignalHashStart(5),
        SignalHashData(6),
        SignalHashEnd(7),
        SendCommand(8),
        SignalCancelOn(9),
        SignalCancelOff(10),
        SignalNvOn(11),
        SignalNvOff(12),
        SignalKeyCacheOn(13),
        SignalKeyCacheOff(14),
        RemoteHandshake(15),
        SessionEnd(20),
        Stop(21),
        TestFailureMode(30);

        private int Val;

        private TcpTpmCommands(int val) {
            this.setVal(val);
        }

        public int getVal() {
            return this.Val;
        }

        public void setVal(int val) {
            this.Val = val;
        }
    }
}

