/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Stack;
import tss.Helpers;
import tss.TpmEnum;
import tss.TpmMarshaller;

public class TpmBuffer {
    ByteBuffer buf;
    boolean outOfBounds;
    Stack<SizedStructInfo> sizedStructSizes;

    void init(byte[] backingBuffer) {
        this.buf = ByteBuffer.wrap(backingBuffer);
        this.sizedStructSizes = new Stack();
        this.outOfBounds = false;
    }

    void init(int capacity) {
        this.init(new byte[capacity]);
    }

    public TpmBuffer() {
        this.init(4096);
    }

    public TpmBuffer(int capacity) {
        this.init(capacity);
    }

    public TpmBuffer(byte[] buf) {
        this.init(buf);
    }

    public void clear() {
        this.buf.clear();
    }

    public void reset() {
        this.clear();
    }

    public byte[] buffer() {
        return this.buf.array();
    }

    public int size() {
        return this.buf.capacity();
    }

    public int curPos() {
        return this.buf.position();
    }

    public void curPos(int newPos) {
        this.buf.position(newPos);
        this.outOfBounds = this.size() < newPos;
    }

    public boolean isOk() {
        return !this.outOfBounds;
    }

    public byte[] trim() {
        if (this.curPos() < this.size()) {
            this.init(Arrays.copyOf(this.buf.array(), this.curPos()));
        }
        return this.buf.array();
    }

    public int getCurStuctRemainingSize() {
        SizedStructInfo ssi = this.sizedStructSizes.peek();
        return ssi.size - (this.curPos() - ssi.startPos);
    }

    boolean checkLen(int len) {
        if (this.size() < this.curPos() + len) {
            this.outOfBounds = true;
            return false;
        }
        return true;
    }

    public void writeNum(long val, int len) {
        if (!this.checkLen(len)) {
            return;
        }
        switch (len) {
            case 1: {
                this.buf.put((byte)val);
                return;
            }
            case 2: {
                this.writeByteBuf(Helpers.hostToNet((short)val));
                return;
            }
            case 4: {
                this.writeByteBuf(Helpers.hostToNet((int)val));
                return;
            }
            case 8: {
                this.writeByteBuf(Helpers.hostToNet(val));
                return;
            }
        }
        assert (false);
    }

    public long readNum(int len) {
        if (!this.checkLen(len)) {
            return 0L;
        }
        switch (len) {
            case 1: {
                return this.buf.get() & 0xFF;
            }
            case 2: {
                return this.buf.getShort() & 0xFFFF;
            }
            case 4: {
                return this.buf.getInt() & 0xFFFFFFFF;
            }
            case 8: {
                return this.buf.getLong();
            }
        }
        assert (false);
        return 0L;
    }

    public void writeNumAtPos(int val, int pos, int len) {
        int curPos = this.curPos();
        this.curPos(pos);
        this.writeNum(val, len);
        this.curPos(curPos);
    }

    public void writeNumAtPos(int val, int pos) {
        this.writeNumAtPos(val, pos, 4);
    }

    public void writeByte(byte val) {
        if (this.checkLen(1)) {
            this.buf.put(val);
        }
    }

    public <T extends TpmEnum<T>> void writeByte(TpmEnum<T> val) {
        this.writeByte((byte)val.toInt());
    }

    public void writeShort(int val) {
        this.writeNum(val, 2);
    }

    public <T extends TpmEnum<T>> void writeShort(TpmEnum<T> val) {
        this.writeShort(val.toInt());
    }

    public void writeInt(int val) {
        this.writeNum(val, 4);
    }

    public <T extends TpmEnum<T>> void writeInt(TpmEnum<T> val) {
        this.writeShort(val.toInt());
    }

    public void writeInt64(long val) {
        this.writeNum(val, 8);
    }

    public byte readByte() {
        return this.checkLen(1) ? this.buf.get() : (byte)0;
    }

    public int readShort() {
        return (int)this.readNum(2);
    }

    public int readInt() {
        return (int)this.readNum(4);
    }

    public long readInt64() {
        return this.readNum(8);
    }

    public void writeByteBuf(byte[] data) {
        int dataSize;
        int n = dataSize = data != null ? data.length : 0;
        if (dataSize == 0 || !this.checkLen(data.length)) {
            return;
        }
        this.buf.put(data, 0, data.length);
    }

    public byte[] readByteBuf(int size) {
        if (!this.checkLen(size)) {
            return null;
        }
        byte[] data = new byte[size];
        this.buf.get(data);
        return data;
    }

    public void writeSizedByteBuf(byte[] data, int sizeLen) {
        this.writeNum(data != null ? data.length : 0, sizeLen);
        this.writeByteBuf(data);
    }

    public void writeSizedByteBuf(byte[] data) {
        this.writeSizedByteBuf(data, 2);
    }

    public byte[] readSizedByteBuf(int sizeLen) {
        return this.readByteBuf((int)this.readNum(sizeLen));
    }

    public byte[] readSizedByteBuf() {
        return this.readSizedByteBuf(2);
    }

    public <T extends TpmMarshaller> T createObj(Class<T> type) {
        TpmMarshaller newObj;
        try {
            newObj = (TpmMarshaller)type.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        newObj.initFromTpm(this);
        return (T)newObj;
    }

    public <T extends TpmMarshaller> void writeSizedObj(T obj) {
        int lenSize = 2;
        if (obj == null) {
            this.writeShort(0);
            return;
        }
        if (!this.checkLen(2)) {
            return;
        }
        int sizePos = this.curPos();
        this.curPos(sizePos + 2);
        obj.toTpm(this);
        int objSize = this.curPos() - (sizePos + 2);
        this.writeNumAtPos(objSize, sizePos, 2);
    }

    public <T extends TpmMarshaller> T createSizedObj(Class<T> type) {
        int size = this.readShort();
        if (size == 0) {
            return null;
        }
        this.sizedStructSizes.push(new SizedStructInfo(this.curPos(), size));
        T newObj = this.createObj(type);
        this.sizedStructSizes.pop();
        return newObj;
    }

    public void writeObjArr(TpmMarshaller[] arr) {
        if (arr == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(arr.length);
        TpmMarshaller[] tpmMarshallerArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TpmMarshaller obj = tpmMarshallerArray[n2];
            if (!this.isOk()) break;
            obj.toTpm(this);
            ++n2;
        }
    }

    public <T extends TpmMarshaller> T[] readObjArr(Class<T> type) {
        int numElems = this.readInt();
        TpmMarshaller[] arr = (TpmMarshaller[])Array.newInstance(type, numElems);
        int i = 0;
        while (i < numElems) {
            if (!this.isOk()) break;
            arr[i] = this.createObj(type);
            ++i;
        }
        return arr;
    }

    public class SizedStructInfo {
        public int startPos;
        public int size;

        public SizedStructInfo(int startPos, int size) {
            this.startPos = startPos;
            this.size = size;
        }
    }
}

