/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import tss.CmdStructure;
import tss.Crypto;
import tss.Helpers;
import tss.ReqStructure;
import tss.RespStructure;
import tss.Tpm;
import tss.TpmBuffer;
import tss.TpmCallbackInterface;
import tss.TpmDevice;
import tss.TpmException;
import tss.TpmHelpers;
import tss.tpm.TPMA_SESSION;
import tss.tpm.TPMT_HA;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_CC;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_HT;
import tss.tpm.TPM_RC;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_ST;

public abstract class TpmBase
implements Closeable {
    public TPM_HANDLE _OwnerHandle = TPM_HANDLE.from(TPM_RH.OWNER);
    public TPM_HANDLE _EndorsementHandle = TPM_HANDLE.from(TPM_RH.ENDORSEMENT);
    public TPM_HANDLE _PlatformHandle = TPM_HANDLE.from(TPM_RH.PLATFORM);
    public TPM_HANDLE _LockoutHandle = TPM_HANDLE.from(TPM_RH.LOCKOUT);
    TpmDevice device;
    TpmCallbackInterface callbackObject;
    TPM_RC lastResponseCode;
    TPMT_HA CommandAuditHash;
    TPMT_HA AuditCpHash;
    boolean AllowErrors = false;
    boolean AuditCommand = false;
    TPM_RC[] ExpectedResponses;
    TPM_HANDLE[] Sessions;
    TPMT_HA CpHash = null;

    public void _setDevice(TpmDevice theDevice) {
        this.device = theDevice;
        this.lastResponseCode = TPM_RC.SUCCESS;
    }

    public TpmDevice _getDevice() {
        return this.device;
    }

    public Tpm _allowErrors() {
        this.AllowErrors = true;
        return (Tpm)this;
    }

    public TPM_RC[] _GetExpectedResponses() {
        return this.ExpectedResponses;
    }

    public Tpm _expectError(TPM_RC expectedResponse) {
        return this._expectResponses(expectedResponse);
    }

    public Tpm _expectResponses(TPM_RC ... expectedResponses) {
        this.ExpectedResponses = null;
        if (expectedResponses.length == 0 || expectedResponses.length == 1 && Helpers.isOneOf(expectedResponses[0], TPM_RC.SUCCESS, null)) {
            return (Tpm)this;
        }
        this.ExpectedResponses = new TPM_RC[0];
        return this._expectMoreResponses(expectedResponses);
    }

    public Tpm _expectMoreResponses(TPM_RC ... expectedResponses) {
        if (this.ExpectedResponses == null) {
            this.ExpectedResponses = new TPM_RC[]{TPM_RC.SUCCESS};
        }
        TPM_RC[] old = this.ExpectedResponses;
        this.ExpectedResponses = new TPM_RC[expectedResponses.length + old.length];
        int i = 0;
        while (i < old.length) {
            this.ExpectedResponses[i] = old[i];
            ++i;
        }
        i = 0;
        while (i < expectedResponses.length) {
            block7: {
                TPM_RC rc;
                block6: {
                    rc = expectedResponses[i];
                    int curPos = old.length + i;
                    if (rc != TPM_RC.SUCCESS || curPos == 0) break block6;
                    if (this.ExpectedResponses[0] == TPM_RC.SUCCESS) break block7;
                    rc = this.ExpectedResponses[0];
                    this.ExpectedResponses[0] = TPM_RC.SUCCESS;
                }
                this.ExpectedResponses[curPos] = rc;
            }
            ++i;
        }
        return (Tpm)this;
    }

    private boolean _isSuccessExpected() {
        return this.ExpectedResponses == null || this.ExpectedResponses[0] == TPM_RC.SUCCESS;
    }

    public Boolean _lastCommandSucceeded() {
        if (this.lastResponseCode == TPM_RC.SUCCESS) {
            return true;
        }
        return false;
    }

    public TPM_RC _getLastResponseCode() {
        return this.lastResponseCode;
    }

    public Tpm _withSession(TPM_HANDLE h) {
        this.Sessions = new TPM_HANDLE[]{h};
        return (Tpm)this;
    }

    public Tpm _withSessions(TPM_HANDLE ... hh) {
        this.Sessions = hh;
        return (Tpm)this;
    }

    public TPM_RC getLastResponseCode() {
        return this.lastResponseCode;
    }

    static void WriteSession(TpmBuffer buf, TPM_HANDLE sessHandle, byte[] nonceCaller, TPMA_SESSION sessAttrs, byte[] authVal) {
        sessHandle.toTpm(buf);
        buf.writeSizedByteBuf(nonceCaller);
        sessAttrs.toTpm(buf);
        buf.writeSizedByteBuf(authVal);
    }

    protected void DispatchCommand(TPM_CC cmdCode, ReqStructure req, RespStructure resp) {
        try {
            String expected;
            TPM_HANDLE[] inHandles = req.getHandles();
            int numAuthHandles = req.numAuthHandles();
            boolean hasSessions = numAuthHandles != 0 || this.Sessions != null;
            int sessTag = hasSessions ? TPM_ST.SESSIONS.toInt() : TPM_ST.NO_SESSIONS.toInt();
            TpmBuffer cmdBuf = new TpmBuffer();
            cmdBuf.writeShort(sessTag);
            cmdBuf.writeInt(0);
            cmdBuf.writeInt(cmdCode.toInt());
            int numHandles = inHandles == null ? 0 : inHandles.length;
            int i = 0;
            while (i < numHandles) {
                inHandles[i].toTpm(cmdBuf);
                ++i;
            }
            TpmBuffer paramBuf = new TpmBuffer();
            req.toTpm(paramBuf);
            paramBuf.trim();
            byte[] cpHashData = null;
            if (hasSessions) {
                int authSizePos = cmdBuf.curPos();
                cmdBuf.writeInt(0);
                int numExplicitSessions = 0;
                if (this.Sessions == null) {
                    this.Sessions = new TPM_HANDLE[numAuthHandles];
                } else {
                    numExplicitSessions = this.Sessions.length;
                    if (numExplicitSessions < numAuthHandles) {
                        this.Sessions = Arrays.copyOf(this.Sessions, numAuthHandles);
                    }
                }
                int i2 = numExplicitSessions;
                while (i2 < numAuthHandles) {
                    this.Sessions[i2] = TPM_HANDLE.PW;
                    ++i2;
                }
                TPMA_SESSION sessAttrs = TPMA_SESSION.continueSession;
                int i3 = 0;
                while (i3 < this.Sessions.length) {
                    boolean needAuth = i3 < numHandles && this.Sessions[i3].getType() != TPM_HT.POLICY_SESSION;
                    TpmBase.WriteSession(cmdBuf, this.Sessions[i3], null, sessAttrs, needAuth ? inHandles[i3].AuthValue : null);
                    ++i3;
                }
                this.Sessions = null;
                cmdBuf.writeNumAtPos(cmdBuf.curPos() - authSizePos - 4, authSizePos);
            }
            cmdBuf.writeByteBuf(paramBuf.buffer());
            cmdBuf.writeNumAtPos(cmdBuf.curPos(), 2);
            if (this.CpHash != null || this.AuditCommand) {
                if (cpHashData == null) {
                    cpHashData = this.GetCpHashData(cmdCode, paramBuf.buffer());
                }
                if (this.CpHash != null) {
                    this.CpHash.digest = Crypto.hash(this.CpHash.hashAlg, cpHashData);
                    this.clearInvocationState();
                    this.Sessions = null;
                    this.CpHash = null;
                    return;
                }
                this.AuditCpHash.digest = Crypto.hash(this.CommandAuditHash.hashAlg, cpHashData);
            }
            byte[] rawCmdBuf = cmdBuf.trim();
            int nvRateRecoveryCount = 4;
            TpmBuffer respBuf = null;
            TPM_ST respTag = TPM_ST.NULL;
            int respSize = 0;
            int rawResponseCode = 0;
            do {
                this.device.dispatchCommand(rawCmdBuf);
                byte[] rawRespBuf = this.device.getResponse();
                respBuf = new TpmBuffer(rawRespBuf);
                respTag = TPM_ST.fromTpm(respBuf);
                respSize = respBuf.readInt();
                rawResponseCode = respBuf.readInt();
                int actRespSize = respBuf.size();
                if (respSize != actRespSize) {
                    throw new TpmException(String.format("Inconsistent TPM response buffer: %d B reported, %d B received", respSize, actRespSize));
                }
                this.lastResponseCode = TpmHelpers.fromRawResponse(rawResponseCode);
                if (this.callbackObject == null) continue;
                this.callbackObject.commandCompleteCallback(cmdCode, this.lastResponseCode, rawCmdBuf, rawRespBuf);
            } while (this.lastResponseCode == TPM_RC.RETRY);
            if (this.lastResponseCode != TPM_RC.NV_RATE || ++nvRateRecoveryCount > 4) {
                // empty if block
            }
            if (this.lastResponseCode != TPM_RC.SUCCESS) {
                if (this.AllowErrors) {
                    return;
                }
                if (Helpers.isOneOf(this.lastResponseCode, this.ExpectedResponses)) {
                    return;
                }
                if (this._isSuccessExpected()) {
                    System.out.println("TPM ERROR: " + this.lastResponseCode);
                    throw new TpmException(this.lastResponseCode, rawResponseCode);
                }
                expected = this.ExpectedResponses.length > 1 ? Arrays.toString(this.ExpectedResponses) : this.ExpectedResponses[0].toString();
                throw new TpmException("Unexpected response {" + this.lastResponseCode + "} instead of {" + expected + "}", this.lastResponseCode);
            }
            if (this.ExpectedResponses != null) {
                expected = this.ExpectedResponses.length > 1 ? "s " + Arrays.toString(this.ExpectedResponses) + " were" : " " + this.ExpectedResponses.toString() + " was";
                throw new TpmException("Error" + expected + " expected, " + "but the TPM command " + cmdCode + " succeeded");
            }
            boolean auditCommand = this.AuditCommand;
            this.clearInvocationState();
            if (respTag.toInt() != sessTag) {
                throw new TpmException("Unexpected response tag " + respTag);
            }
            if (resp == null) {
                resp = new RespStructure();
            }
            if (resp.numHandles() > 0) {
                assert (resp.numHandles() == 1);
                resp.setHandle(TPM_HANDLE.fromTpm(respBuf));
            }
            boolean rpReady = false;
            int respParamsPos = 0;
            int respParamsSize = 0;
            if (respTag == TPM_ST.SESSIONS) {
                respParamsSize = respBuf.readInt();
                respParamsPos = respBuf.curPos();
                rpReady = this.processRespSessions(respBuf, cmdCode, respParamsPos, respParamsSize);
            } else {
                respParamsPos = respBuf.curPos();
                respParamsSize = respBuf.size() - respParamsPos;
            }
            if (auditCommand) {
                byte[] rpHash = this.getRpHash(this.CommandAuditHash.hashAlg, respBuf, cmdCode, respParamsPos, respParamsSize, rpReady);
                this.CommandAuditHash.extend(Helpers.concatenate(this.AuditCpHash.digest, rpHash));
            }
            this.doParmEncryption(resp, respBuf, respParamsPos, false);
            respBuf.curPos(respParamsPos);
            resp.initFromTpm(respBuf);
            if (respBuf.curPos() != respParamsPos + respParamsSize) {
                throw new TpmException("Bad response parameters area");
            }
            this.updateRespHandle(cmdCode, resp);
            this.Sessions = null;
        }
        finally {
            this.clearInvocationState();
        }
    }

    void clearInvocationState() {
        this.AllowErrors = false;
        this.ExpectedResponses = null;
        this.AuditCommand = false;
    }

    byte[] GetCpHashData(TPM_CC cmdCode, byte[] cmdParams) {
        return null;
    }

    byte[] getRpHash(TPM_ALG_ID hashAlg, TpmBuffer respBuf, TPM_CC cmdCode, int respParamsPos, int respParamsSize, boolean rpReady) {
        return null;
    }

    void doParmEncryption(CmdStructure cmd, TpmBuffer paramBuf, int startPos, boolean request) {
    }

    boolean processRespSessions(TpmBuffer b, TPM_CC cmdCode, int respParamsPos, int respParamsSize) {
        return false;
    }

    void updateRespHandle(TPM_CC cc, RespStructure resp) {
    }

    public void _setCallback(TpmCallbackInterface callback) {
        this.callbackObject = callback;
    }

    @Override
    public void close() throws IOException {
        this.device.close();
        this.device = null;
    }
}

