/*
 * Decompiled with CFR 0.152.
 */
package samples;

import java.io.IOException;
import tss.Helpers;
import tss.Tpm;
import tss.TpmDeviceTcp;
import tss.TpmException;
import tss.TpmFactory;
import tss.tpm.HashResponse;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_RC;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_SU;

public class DocSamples {
    Tpm tpm;

    public DocSamples() {
        boolean useSimulator = true;
        this.tpm = useSimulator ? TpmFactory.localTpmSimulator() : TpmFactory.platformTpm();
    }

    public void doAll() {
        this.arrays();
        this.enumerations();
        this.pwapAuth();
        this.errors();
        try {
            if (this.tpm._getDevice() instanceof TpmDeviceTcp) {
                this.tpm.Shutdown(TPM_SU.CLEAR);
            }
            this.tpm.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void arrays() {
        byte[] r = this.tpm.GetRandom(20);
        System.out.println("GetRandom: " + Helpers.toHex(r));
        byte[] seedData = new byte[]{2, 7, 1, 8, 2, 8};
        this.tpm.StirRandom(seedData);
    }

    void enumerations() {
        byte[] dataToHash = new byte[]{3, 1, 4, 1, 5, 9};
        TPM_ALG_ID hashAlg = TPM_ALG_ID.SHA256;
        HashResponse digestValue = this.tpm.Hash(dataToHash, hashAlg, TPM_HANDLE.NULL);
        System.out.println("Hash of: " + Helpers.toHex(dataToHash) + "\nWith algorithm: " + hashAlg.toString() + "\nis: " + Helpers.toHex(digestValue.outHash));
    }

    void pwapAuth() {
        TPM_HANDLE platformHandle = TPM_HANDLE.from(TPM_RH.PLATFORM);
        this.tpm.Clear(platformHandle);
        byte[] newAuth = new byte[]{1, 2, 3, 4};
        this.tpm.HierarchyChangeAuth(platformHandle, newAuth);
        platformHandle.AuthValue = newAuth;
        this.tpm.Clear(platformHandle);
        this.tpm.HierarchyChangeAuth(platformHandle, new byte[0]);
    }

    void errors() {
        TPM_HANDLE invalidHandle = new TPM_HANDLE(-1);
        try {
            this.tpm.ReadPublic(invalidHandle);
        }
        catch (TpmException e) {
            System.out.println("As expected, the TPM returned an error: " + e.toString());
        }
        this.tpm._allowErrors().ReadPublic(invalidHandle);
        if (this.tpm._getLastResponseCode() != TPM_RC.SUCCESS) {
            System.out.println("Command failed but no exception was thrown, as expected");
        }
        this.tpm._expectError(TPM_RC.VALUE).ReadPublic(invalidHandle);
    }
}

