/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.BufferedTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.ComponentColor;
import com.metaweb.lessen.tokens.NumericToken;
import com.metaweb.lessen.tokens.Token;

public class RegroupingTokenizer
implements Tokenizer {
    protected final BufferedTokenizer _tokenizer;
    protected Token _token;

    public RegroupingTokenizer(Tokenizer tokenizer) {
        this._tokenizer = new BufferedTokenizer(tokenizer);
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    public Token getToken() {
        return this._token;
    }

    public void next() {
        this._tokenizer.next();
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    protected Token eatWhitespaceAndComment(StringBuffer sb) {
        Token t;
        while ((t = this._tokenizer.getToken()) != null && (t.type == Token.Type.Whitespace || t.type == Token.Type.Comment)) {
            sb.append(t.text);
            this._tokenizer.next();
        }
        return t;
    }

    protected void resolve() {
        if (this._token != null && this._token.type == Token.Type.Function && (this._token.text.equals("rgb(") || this._token.text.equals("rgba("))) {
            int tokenStart = this._token.start;
            StringBuffer sb = new StringBuffer();
            sb.append(this._token.text);
            this._tokenizer.next();
            this._token = this.eatWhitespaceAndComment(sb);
            NumericToken[] components = new NumericToken[4];
            int component = 0;
            while (component < components.length && this._token != null && this._token instanceof NumericToken && (this._token.type == Token.Type.Percentage || this._token.type == Token.Type.Number)) {
                components[component++] = (NumericToken)this._token;
                sb.append(this._token.text);
                this._tokenizer.next();
                this._token = this.eatWhitespaceAndComment(sb);
                if (this._token == null || this._token.type != Token.Type.Delimiter || !this._token.text.equals(",")) continue;
                sb.append(this._token.text);
                this._tokenizer.next();
                this._token = this.eatWhitespaceAndComment(sb);
            }
            if (this._token != null && this._token.type == Token.Type.Delimiter && this._token.text.equals(")")) {
                sb.append(this._token.text);
            }
            String text = sb.toString();
            ComponentColor newToken = new ComponentColor(tokenStart, tokenStart += text.length(), text, components[0], components[1], components[2], components[3]);
            this._token = newToken;
        }
    }
}

