/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.BufferedTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.Token;

public class CondensingTokenizer
implements Tokenizer {
    protected final BufferedTokenizer _tokenizer;
    protected final boolean _removeComments;
    protected Token _token;

    public CondensingTokenizer(Tokenizer tokenizer) {
        this(tokenizer, true);
    }

    public CondensingTokenizer(Tokenizer tokenizer, boolean removeComments) {
        this._tokenizer = new BufferedTokenizer(tokenizer);
        this._removeComments = removeComments;
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    public Token getToken() {
        return this._token;
    }

    public void next() {
        this._tokenizer.next();
        this._token = this._tokenizer.getToken();
        this.resolve();
    }

    protected void resolve() {
        while (this._removeComments && this._token != null && this._token.type == Token.Type.Comment) {
            this._tokenizer.next();
            this._token = this._tokenizer.getToken();
        }
        if (this._token != null && this._token.type == Token.Type.Whitespace) {
            Token t;
            StringBuffer sb = new StringBuffer();
            sb.append(this._token.text);
            int lookahead = 1;
            while ((t = this._tokenizer.getToken(lookahead)) != null && (t.type == Token.Type.Whitespace || this._removeComments && t.type == Token.Type.Comment)) {
                if (t.type == Token.Type.Whitespace) {
                    sb.append(t.text);
                }
                ++lookahead;
            }
            this._tokenizer.next(lookahead - 1);
            this._token = new Token(this._token.type, this._token.start, this._token.end, sb.toString().indexOf(10) < 0 ? " " : "\n");
        }
    }
}

