/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tests;

import com.metaweb.lessen.LessParser;
import com.metaweb.lessen.Utilities;
import com.metaweb.lessen.tokens.Token;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class TestCssPreserving {
    public static void main(String[] args) {
        try {
            TestCssPreserving.testCssURL("http://52.global.apps.freebase.dev.freebaseapps.com/css-metaweb-global.css");
            TestCssPreserving.testCssURL("http://freebaselibs.com/static/suggest/1.2.1/suggest.min.css");
            TestCssPreserving.testCssURL("http://graphics8.nytimes.com/css/0.1/screen/build/homepage/styles.css");
            TestCssPreserving.testCssURL("http://graphics8.nytimes.com/css/0.1/print/styles.css");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean testCssURL(String urlString) throws Exception {
        Token t;
        String input = TestCssPreserving.loadFromURL(urlString);
        StringBuffer sb = new StringBuffer();
        LessParser tokenizer = new LessParser(Utilities.open(input), null);
        while ((t = tokenizer.getToken()) != null) {
            sb.append(t.text);
            tokenizer.next();
        }
        String output = sb.toString();
        boolean r = input.equals(output);
        if (r) {
            System.err.println("\n\n---------- Preserved " + urlString + " ----------");
        } else {
            String inputLine;
            int i;
            System.err.println("\n\n----------  Error preserving " + urlString + " " + (output.length() - input.length()) + " ----------");
            String[] inputLines = input.split("\n");
            String[] outputLines = output.split("\n");
            for (i = 0; i < inputLines.length && i < outputLines.length; ++i) {
                inputLine = inputLines[i];
                String outputLine = outputLines[i];
                if (inputLine.equals(outputLine)) continue;
                System.err.println("~" + i + ": " + outputLine);
            }
            while (i < inputLines.length) {
                inputLine = inputLines[i];
                System.err.println("-: " + inputLine);
                ++i;
            }
            while (i < outputLines.length) {
                String outputLine = outputLines[i];
                System.err.println("+: " + outputLine);
                ++i;
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String loadFromURL(String urlString) throws Exception {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        String encoding = conn.getContentEncoding();
        InputStreamReader reader = encoding != null ? new InputStreamReader(conn.getInputStream(), encoding) : new InputStreamReader(conn.getInputStream());
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            char[] buffer = new char[4096];
            while ((c = reader.read(buffer)) >= 0) {
                sb.append(buffer, 0, c);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return sb.toString();
    }
}

