/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen;

import com.metaweb.lessen.FileResourceFinder;
import com.metaweb.lessen.LessParser;
import com.metaweb.lessen.ResourceFinder;
import com.metaweb.lessen.Scope;
import com.metaweb.lessen.URLResourceFinder;
import com.metaweb.lessen.VariableResolvingResourceFinder;
import com.metaweb.lessen.tokenizers.ReaderTokenizer;
import com.metaweb.lessen.tokenizers.RegroupingTokenizer;
import com.metaweb.lessen.tokenizers.StringTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokenizers.VariableResolvingTokenizer;
import com.metaweb.lessen.tokens.Token;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static Tokenizer open(String s) {
        return Utilities.wrap(new StringTokenizer(s));
    }

    public static Tokenizer open(Reader reader) {
        return Utilities.wrap(new ReaderTokenizer(reader));
    }

    public static Tokenizer open(File file) throws FileNotFoundException {
        return Utilities.open(new FileReader(file));
    }

    public static Tokenizer open(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        String encoding = conn.getContentEncoding();
        InputStreamReader reader = encoding != null ? new InputStreamReader(conn.getInputStream(), encoding) : new InputStreamReader(conn.getInputStream());
        return Utilities.open(reader);
    }

    public static Tokenizer openLess(File file, Map<String, String> variables) throws FileNotFoundException {
        return Utilities.openLess(file, variables, new Scope(null));
    }

    public static Tokenizer openLess(File file, Map<String, String> variables, Scope scope) throws FileNotFoundException {
        return Utilities.wrapLess(Utilities.open(file), new FileResourceFinder(file), variables, scope);
    }

    public static Tokenizer openLess(URL url, Map<String, String> variables) throws IOException {
        return Utilities.openLess(url, variables, new Scope(null));
    }

    public static Tokenizer openLess(URL url, Map<String, String> variables, Scope scope) throws IOException {
        return Utilities.wrapLess(Utilities.open(url), new URLResourceFinder(url), variables, scope);
    }

    public static void write(Tokenizer tokenizer, Writer writer) throws IOException {
        Token t;
        while ((t = tokenizer.getToken()) != null) {
            writer.write(t.getCleanText());
            tokenizer.next();
        }
    }

    public static void print(Tokenizer tokenizer, PrintStream ps) throws IOException {
        Token t;
        while ((t = tokenizer.getToken()) != null) {
            ps.print(t.getCleanText());
            tokenizer.next();
        }
    }

    protected static Tokenizer wrap(Tokenizer t) {
        return new RegroupingTokenizer(t);
    }

    protected static Tokenizer wrapLess(Tokenizer tokenizer, ResourceFinder resourceFinder, Map<String, String> variables, Scope scope) {
        tokenizer = new LessParser(variables == null ? tokenizer : new VariableResolvingTokenizer(tokenizer, variables, true), variables == null ? resourceFinder : new VariableResolvingResourceFinder(resourceFinder, variables), scope);
        return tokenizer;
    }
}

