/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen;

import com.metaweb.lessen.ParserBase;
import com.metaweb.lessen.ResourceFinder;
import com.metaweb.lessen.Scope;
import com.metaweb.lessen.tokenizers.BufferedTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.Token;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockParser
extends ParserBase
implements Tokenizer {
    protected List<Token> _pathTokens = new ArrayList<Token>();
    protected Token _openToken;
    protected List<Token> _bodyTokens = new ArrayList<Token>();
    protected Token _closeToken;
    protected boolean _nestChildren;
    protected List<Token> _childrenTokens = new ArrayList<Token>();

    public BlockParser(BufferedTokenizer tokenizer, ResourceFinder resourceFinder, Scope scope, List<Token> parentPathTokens, boolean nestChildren) {
        super(tokenizer, resourceFinder, scope, false);
        this._nestChildren = nestChildren;
        if (parentPathTokens != null) {
            this._pathTokens.addAll(parentPathTokens);
        }
        this.parse();
    }

    @Override
    public Token getToken() {
        if (this._pathTokens.size() > 0) {
            return this._pathTokens.get(0);
        }
        if (this._openToken != null) {
            return this._openToken;
        }
        if (this._bodyTokens.size() > 0) {
            return this._bodyTokens.get(0);
        }
        if (this._closeToken != null) {
            return this._closeToken;
        }
        if (this._childrenTokens.size() > 0) {
            return this._childrenTokens.get(0);
        }
        return null;
    }

    @Override
    public void next() {
        if (this._pathTokens.size() > 0) {
            this._pathTokens.remove(0);
            return;
        }
        if (this._openToken != null) {
            this._openToken = null;
            return;
        }
        if (this._bodyTokens.size() > 0) {
            this._bodyTokens.remove(0);
            return;
        }
        if (this._closeToken != null) {
            this._closeToken = null;
            return;
        }
        if (this._childrenTokens.size() > 0) {
            this._childrenTokens.remove(0);
            return;
        }
    }

    protected void parse() {
        Token tLastPath;
        Token tFirst = this._tokenizer.getToken();
        if (tFirst == null) {
            return;
        }
        if (tFirst.type == Token.Type.Delimiter && tFirst.text.equals(":")) {
            if (this._pathTokens.size() > 0) {
                tLastPath = this._pathTokens.get(this._pathTokens.size() - 1);
                if (tLastPath.type == Token.Type.Whitespace) {
                    this._pathTokens.remove(this._pathTokens.size() - 1);
                }
            }
        } else if (this._pathTokens.size() > 0) {
            tLastPath = this._pathTokens.get(this._pathTokens.size() - 1);
            if (tLastPath.type != Token.Type.Whitespace) {
                this._pathTokens.add(new Token(Token.Type.Whitespace, tFirst.start, tFirst.start, " "));
            }
        }
        Token t = tFirst;
        while (!(t == null || t.type == Token.Type.Delimiter && t.text.equals("{"))) {
            this._pathTokens.add(t);
            this._tokenizer.next();
            t = this._tokenizer.getToken();
        }
        if (t != null && t.type == Token.Type.Delimiter && t.text.equals("{")) {
            this._openToken = t;
            this._tokenizer.next();
        }
        this.parseBody();
        t = this._tokenizer.getToken();
        if (t != null && t.type == Token.Type.Delimiter && t.text.equals("}")) {
            this._closeToken = t;
            this._tokenizer.next();
        }
    }

    @Override
    protected Tokenizer createCssBlockParser(boolean nestChildren) {
        if (!this._nestChildren) {
            this.passInnerBlockTokenThrough(new Token(Token.Type.Whitespace, -1, -1, "\n"));
        }
        return new BlockParser(this._tokenizer, this._resourceFinder, new Scope(this._scope), this._nestChildren ? null : this._pathTokens, nestChildren);
    }

    @Override
    protected void outputToken(Token t) {
        this._bodyTokens.add(t);
    }

    @Override
    protected void passInnerBlockTokenThrough(Token t) {
        if (this._nestChildren) {
            this._bodyTokens.add(t);
        } else {
            this._childrenTokens.add(t);
        }
    }
}

