/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs;

import com.luhuiguo.fastdfs.FdfsProperties;
import com.luhuiguo.fastdfs.conn.ConnectionManager;
import com.luhuiguo.fastdfs.conn.ConnectionPoolConfig;
import com.luhuiguo.fastdfs.conn.FdfsConnectionPool;
import com.luhuiguo.fastdfs.conn.PooledConnectionFactory;
import com.luhuiguo.fastdfs.conn.TrackerConnectionManager;
import com.luhuiguo.fastdfs.service.AppendFileStorageClient;
import com.luhuiguo.fastdfs.service.DefaultAppendFileStorageClient;
import com.luhuiguo.fastdfs.service.DefaultFastFileStorageClient;
import com.luhuiguo.fastdfs.service.DefaultTrackerClient;
import com.luhuiguo.fastdfs.service.FastFileStorageClient;
import com.luhuiguo.fastdfs.service.TrackerClient;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FdfsProperties.class})
public class FdfsAutoConfiguration {
    private final FdfsProperties properties;

    public FdfsAutoConfiguration(FdfsProperties properties) {
        this.properties = properties;
    }

    @Bean
    public PooledConnectionFactory pooledConnectionFactory() {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setSoTimeout(this.properties.getSoTimeout());
        pooledConnectionFactory.setConnectTimeout(this.properties.getConnectTimeout());
        return pooledConnectionFactory;
    }

    @Bean
    @ConfigurationProperties(prefix="fdfs.pool")
    public ConnectionPoolConfig connectionPoolConfig() {
        ConnectionPoolConfig connectionPoolConfig = new ConnectionPoolConfig();
        return connectionPoolConfig;
    }

    @Bean
    public FdfsConnectionPool fdfsConnectionPool(PooledConnectionFactory pooledConnectionFactory, ConnectionPoolConfig connectionPoolConfig) {
        FdfsConnectionPool pool = new FdfsConnectionPool((KeyedPooledObjectFactory)pooledConnectionFactory, (GenericKeyedObjectPoolConfig)connectionPoolConfig);
        return pool;
    }

    @Bean
    public TrackerConnectionManager trackerConnectionManager(FdfsConnectionPool fdfsConnectionPool) {
        return new TrackerConnectionManager(fdfsConnectionPool, this.properties.getTrackerList());
    }

    @Bean
    public TrackerClient trackerClient(TrackerConnectionManager trackerConnectionManager) {
        return new DefaultTrackerClient(trackerConnectionManager);
    }

    @Bean
    public ConnectionManager connectionManager(FdfsConnectionPool fdfsConnectionPool) {
        return new ConnectionManager(fdfsConnectionPool);
    }

    @Bean
    public FastFileStorageClient fastFileStorageClient(TrackerClient trackerClient, ConnectionManager connectionManager) {
        return new DefaultFastFileStorageClient(trackerClient, connectionManager);
    }

    @Bean
    public AppendFileStorageClient appendFileStorageClient(TrackerClient trackerClient, ConnectionManager connectionManager) {
        return new DefaultAppendFileStorageClient(trackerClient, connectionManager);
    }
}

