package com.libawall.util.httpclient;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlEncodeUtil {
	private static Log log = LogFactory.getLog(UrlEncodeUtil.class);
	private static final URLCodec encoder = new URLCodec("UTF-8");

	public static String encodeURL(String url) {
		try {
			return encoder.encode(url);
		} catch (EncoderException e) {
			log.error(e, e);
		}
		return url;
	}

	public static String decodeURL(String url) {
		try {
			return encoder.decode(url);
		} catch (DecoderException e) {
			log.error(e, e);
		}
		return url;
	}
}
