package com.libawall.api.util.exception;


import org.apache.commons.lang3.StringUtils;

/**
 * 接口调用返回参数封装对象
 *
 * @author 石超
 **/
public class ResultDTO<T> implements java.io.Serializable {

    public static final ResultDTO<Boolean> DEFAULT_SUCCESS_RESULT = new ResultDTO<>();
    /**
     * 结果返回的code
     */
    private ResultCode code = DefaultResultCode.SUCCESS;
    /**
     * 备注信息
     */
    private String errMsg;
    /**
     * 结果返回的业务数据
     */
    private T data;

    public static <T> ResultDTO<T> ok() {
        return (ResultDTO<T>) DEFAULT_SUCCESS_RESULT;
    }

    public static <T> ResultDTO<T> ok(T t) {
        return new ResultDTO<>(t);
    }

    public static <T> ResultDTO<T> error(ResultCode code) {
        return new ResultDTO<>(code);
    }

    public static <T> ResultDTO<T> error(ResultCode code, String errMsg) {
        return new ResultDTO<>(code, errMsg);
    }

    public ResultDTO() {
        super();
    }

    public ResultDTO(ResultCode code) {
        putError(code);
    }

    public ResultDTO(ResultCode code, String errMsg) {
        putError(code, errMsg);
    }

    public ResultDTO(T t) {
        data = t;
    }

    public ResultDTO(Integer code,String errMsg) {
        this.code = DefaultResultCode.getInstance(code, errMsg);
        this.errMsg = errMsg;
    }

    /**
     * 操作是否成功
     *
     * @return
     */
    public boolean isSuccess() {
        return DefaultResultCode.SUCCESS == code;
    }

    /**
     * 设置操作成功
     */
    public void markSuccess() {
        this.code = DefaultResultCode.SUCCESS;
    }

    /**
     * 填充错误信息
     *
     * @param error
     */
    public void putError(ResultCode error) {
        this.putError(error, null);
    }

    /**
     * 填充错误信息
     *
     * @param error
     * @param msg
     */
    public void putError(ResultCode error, String msg) {
        if (error != null) {
            this.code = error;
            if (StringUtils.isEmpty(msg)) {
                this.errMsg = error.getMsg();
            } else {
                this.errMsg = msg;
            }
        }
    }

    /**
     * 填充错误信息
     *
     * @param error
     */
    public void putError(ResultDTO<?> error) {
        this.code = error.getCode();
        if (StringUtils.isEmpty(error.getErrMsg())) {
            this.errMsg = error.getCode().getMsg();
        } else {
            this.errMsg = error.getErrMsg();
        }
    }

    public ResultCode getCode() {
        return code;
    }

    public void setCode(ResultCode code) {
        this.code = code;
    }

    public int getResultCode() {
        return code.getCode();
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}

