package com.libawall.api.util.exception;

import java.io.Serializable;

/**
 * ResultCode
 *
 * @author YeKaiQiang
 * @date 2016/5/18
 */
public interface ResultCode extends Serializable {

    int getCode();

    String getMsg();

    default WebException getInstance() {
        return new WebException(this);
    }

    default WebException getInstance(Exception e) {
        return new WebException(this, e);
    }

    default WebException format(Object... strs) {
        return new WebException(this, String.format(getMsg(), strs));
    }

    default WebException format(Exception e, Object... strs) {
        return new WebException(this, String.format(getMsg(), strs), e);
    }
}
