package com.libawall.api.util.exception;

import java.util.Arrays;
import java.util.Optional;

/**
 * DefaultResultCode
 *
 * @author 石超
 * @date 2016/5/18
 */
public enum DefaultResultCode implements ResultCode {
    //成功
    SUCCESS(0, "success"),

    ERROR_REQUEST_FREQUENT(400, "请求过于频繁,请稍后再试"),
    ERROR_REQUEST_BAD_REQUEST(400, "请求失败,Bad Request"),
    ERROR_REQUEST_MISSING_PARAM(400, "请求失败,缺失参数"),
    NOT_ALLOWED_OPERATION(401, "无权限进行此操作"),
    ERROR_REQUEST_FORBIDDEN(403, "无权访问页面"),
    ERROR_REQUEST_NOT_FIND(404, "请求失败,该地址不存在或已删除"),
    ERROR_URL_REQUEST(404, "没有该页面"),
    ERROR_REQUEST_METHOD_NOT_ALLOWED(405, "请求失败,请求方法不正确"),
    ERROR_REQUEST_CONTENT_TYPE_NOT_ALLOWED(405, "请求失败,内容类型不正确"),
    ERROR_REQUEST_UNSUPPORTED_MEDIA_TYPE(415, "请求失败,不支持的媒体类型"),
    ERROR_REQUEST_NOT_ACCEPTABLE(406, "请求失败,不能接受的请求地址"),
    ERROR_REQUEST_INTERNAL_SERVER_ERROR(500, "请求失败,内部服务器错误"),
    SYSTEM_ERROR(503, "系统繁忙,请联系管理员"),
    DAO_ERROR(701, "SQL出现异常, 请联系管理员"),
    RUNTIME_ERROR(702, "运行异常, 请联系管理员"),
    SYSTEM_ERROR_FORMAT(1001, "系统异常:%s"),


    ERROR_SELECT_IS_NULL(1000, "数据不存在或已删除,请重试"),
    ILLEGAL_ARGUMENT(1001, "参数错误,请重试或联系管理员"),
    ILLEGAL_ARGUMENT_CHECK(1001, "参数校验失败:%s"),
    ILLEGAL_ARGUMENT_CHECK_DEFAULT(1001, "%s"),
    ERROR_INVALID_PASSWORD(1002, "密码错误"),
    IMPORT_ERROR(1007, " "),
    ;

    private final int code;

    private final String msg;

    DefaultResultCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    public static DefaultResultCode getInstance(int code) {
        Optional<DefaultResultCode> first = Arrays.stream(values()).filter(resultCode -> resultCode.code == code).findFirst();

        return first.orElse(DefaultResultCode.ERROR_REQUEST_NOT_FIND);
    }

    public static ResultCode getInstance(int code, String msg) {
        return new DResultCode(code, msg);
    }

    @Override
    public String toString() {
        return code + ":" + msg;
    }

    private static class DResultCode implements ResultCode {
        private int code;

        private String msg;

        public DResultCode(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        @Override
        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        @Override
        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}
