package com.libawall.api.util.exception;


/**
 * AppException
 *
 * @author shichao
 * @date 2016/7/1
 */
public abstract class AppException extends RuntimeException {
    private ResultDTO resultDTO;

    public AppException() {
    }

    public AppException(ResultCode resultCode) {
        super(resultCode == null ? null : resultCode.getCode() + ":" + resultCode.getMsg());
        putError(resultCode);
    }

    public AppException(ResultCode resultCode, Throwable throwable) {
        super(resultCode == null ? throwable.getMessage() : resultCode.getMsg(), throwable);
        putError(resultCode);
    }

    public AppException(ResultCode resultCode, String msg) {
        super(resultCode == null ? msg : resultCode.getMsg() + ":" + msg);
        putError(resultCode, msg);
    }

    public AppException(ResultCode resultCode, String msg, Throwable throwable) {
        super(resultCode == null ? null : resultCode.getMsg() + ":" + msg, throwable);
        putError(resultCode, msg);
    }

    public ResultCode getResultCode() {
        return resultDTO.getCode();
    }

    public ResultDTO getResultDTO() {
        return resultDTO;
    }

    private void putError(ResultCode resultCode, String msg) {
        if (resultCode != null) {
            this.resultDTO = ResultDTO.error(resultCode, msg);
        }
    }

    private void putError(ResultCode resultCode) {
        if (resultCode != null) {
            this.resultDTO = ResultDTO.error(resultCode);
        }
    }
}
