package com.libawall.api.user.response;

import java.time.LocalDateTime;
import java.util.List;

public class UserResponse {
    /**
     * 用户id
     */
    private Long staffId;
    /**
     * 姓名
     */
    private String name;
    /**
     * 用户头像
     */
    private Long avatarId;

    /**
     * 用户头像地址
     */
    private String fullAvatar;

    /**
     * 登录账号
     */
    private String account;

    /**
     * 员工类型
     * 标记类型（1-超管；2-普通用户）
     */
    private Long identity;

    /**
     * 状态 (1:启用  0:禁用)
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 印得安第三方用户唯一标识(优先使用手机号为唯一标识)
     */
    private String govStaff;

    private List<UserDepartmentRelResponse> departmentIdVOList;

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAvatarId() {
        return avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Long getIdentity() {
        return identity;
    }

    public void setIdentity(Long identity) {
        this.identity = identity;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getFullAvatar() {
        return fullAvatar;
    }

    public void setFullAvatar(String fullAvatar) {
        this.fullAvatar = fullAvatar;
    }

    public String getGovStaff() {
        return govStaff;
    }

    public void setGovStaff(String govStaff) {
        this.govStaff = govStaff;
    }

    public List<UserDepartmentRelResponse> getDepartmentIdVOList() {
        return departmentIdVOList;
    }

    public void setDepartmentIdVOList(List<UserDepartmentRelResponse> departmentIdVOList) {
        this.departmentIdVOList = departmentIdVOList;
    }
}
