package com.libawall.api.user.request;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 用户修改
 */
public class UserUpDateRequest implements SdkRequest<BaseResponse<Boolean>> {

    /**
     * 用户id
     */
    private Long staffId;
    /**
     * 用户名
     */
    private String name;

    /**
     * 角色id
     */
    private List<Long> roleId;

    /**
     * 部门id
     */
    private List<Long> deptIds;

    /**
     *印得安第三方用户唯一标识
     */
    private String govStaff;

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Long> getRoleId() {
        return roleId;
    }

    public void setRoleId(List<Long> roleId) {
        this.roleId = roleId;
    }

    public List<Long> getDeptIds() {
        return deptIds;
    }

    public void setDeptIds(List<Long> deptIds) {
        this.deptIds = deptIds;
    }

    public String getGovStaff() {
        return govStaff;
    }

    public void setGovStaff(String govStaff) {
        this.govStaff = govStaff;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/user";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }
}
