package com.libawall.api.user.request;


import com.libawall.api.user.response.UserResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 用户查询
 */
public class UserQueryRequest extends PaginationQuery implements SdkRequest<PageResponse<UserResponse>> {
    /**
     * 用户名或登录手机号或登陆账号
     */
    private String search;

    /**
     * 登录账号严格搜索
     */
    private String account;

    /**
     * 印得安第三方用户唯一标识(优先使用手机号为唯一标识)
     */
    private String govStaff;

    /**
     * 部门id数组
     */
    private List<Long> deptIds;

    public String getSearch() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getGovStaff() {
        return govStaff;
    }

    public void setGovStaff(String govStaff) {
        this.govStaff = govStaff;
    }


    public List<Long> getDeptIds() {
        return deptIds;
    }

    public void setDeptIds(List<Long> deptIds) {
        this.deptIds = deptIds;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/user";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
