package com.libawall.api.user.request;


import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 初始化密码
 */
public class UserPassWordInitRequest implements SdkRequest<BaseResponse<Boolean>> {
    /**
     * 用户id
     */
    private Long staffId;

    /**
     * 新密码
     */
    private String newPassword;

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/user/password/init";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }
}
