package com.libawall.api.seal.response;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 印章分页查询
 */
public class SealPageResponse {
    /**
     * 印章id
     */
    private Long sealId;

    /**
     * 印章名称
     */
    private String sealName;

    /**
     * 保管人名称
     */
    private String custodianName;

    /**
     * 保管人id
     */
    private Long custodianId;

    /**
     * 设备编号
     */
    private String number;

    /**
     * 印章类型（1.沾墨，2.非沾墨）
     */
    private Integer type;

    /**
     * 印章具体位置
     */
    private String address;

    /**
     * 位置更新时间
     */
    private LocalDateTime uploadTime;

    /**
     * 设备在线状态 0:离线;1:在线
     */
    private Integer deviceState;

    /**
     * 围栏类型 1、无电子围栏，2、围栏范围内，3、已超出
     */
    private Integer railType;

    /**
     * 印章 特权人 集合
     */
    private List<SealStaffRelResponse> staffRelVOList;


    /**
     * 印章 保管人 集合
     */
    private List<SealTrusteeResponse> custodianVOList;

    /**
     * 印章数据查看人集合
     */
    private List<SealDataResponse> sealDataVOList;

    /**
     * 是否锁定 0:未锁定 1:锁定
     */
    private Integer isLock;

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    public String getCustodianName() {
        return custodianName;
    }

    public void setCustodianName(String custodianName) {
        this.custodianName = custodianName;
    }

    public Long getCustodianId() {
        return custodianId;
    }

    public void setCustodianId(Long custodianId) {
        this.custodianId = custodianId;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LocalDateTime getUploadTime() {
        return uploadTime;
    }

    public void setUploadTime(LocalDateTime uploadTime) {
        this.uploadTime = uploadTime;
    }

    public Integer getDeviceState() {
        return deviceState;
    }

    public void setDeviceState(Integer deviceState) {
        this.deviceState = deviceState;
    }

    public Integer getRailType() {
        return railType;
    }

    public void setRailType(Integer railType) {
        this.railType = railType;
    }

    public List<SealStaffRelResponse> getStaffRelVOList() {
        return staffRelVOList;
    }

    public void setStaffRelVOList(List<SealStaffRelResponse> staffRelVOList) {
        this.staffRelVOList = staffRelVOList;
    }

    public List<SealDataResponse> getSealDataVOList() {
        return sealDataVOList;
    }

    public void setSealDataVOList(List<SealDataResponse> sealDataVOList) {
        this.sealDataVOList = sealDataVOList;
    }

    public Integer getIsLock() {
        return isLock;
    }

    public void setIsLock(Integer isLock) {
        this.isLock = isLock;
    }

    public List<SealTrusteeResponse> getCustodianVOList() {
        return custodianVOList;
    }

    public void setCustodianVOList(List<SealTrusteeResponse> custodianVOList) {
        this.custodianVOList = custodianVOList;
    }
}
