package com.libawall.api.seal.request;


import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 印章围栏修改
 */
public class SealRailDeleteRequest implements JsonSdkRequest<BaseResponse<Boolean>> {
    /**
     * 围栏id
     */
    private final transient Long id;

    public SealRailDeleteRequest(Long id){
        this.id=id;
    }
    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal/rail/"+id;
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.DELETE;
    }
}
