package com.libawall.api.seal.request;

import com.libawall.api.seal.response.SealIdResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.JsonSdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * 根据印章名称获取印章id,无印章时自动创建并返回印章id
 * yda_seal
 * @author
 */
public class SealAddByNameRequest implements JsonSdkRequest<BaseResponse<SealIdResponse>> {
    /**
     * 印章名称
     */
    private String sealName;

    public String getSealName() {
        return sealName;
    }

    public void setSealName(String sealName) {
        this.sealName = sealName;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/seal/selectBySealName";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }
}
