package com.libawall.api.oauth.request;


import com.libawall.api.oauth.response.GetToken;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 获取token-请求
 */
public class GetTokenRequest implements SdkRequest<GetToken> {

    /**
     * 认证类型
     */
    private final String grant_type="client_credentials";
    /**
     * 权限
     */
    private final String scope="scope1";
    /**
     * 客户端id
     */
    private String client_id;
    /**
     * 客户端密钥
     */
    private String client_secret;

    public String getGrant_type() {
        return grant_type;
    }

    public String getScope() {
        return scope;
    }

    public String getClient_id() {
        return client_id;
    }

    public void setClient_id(String client_id) {
        this.client_id = client_id;
    }

    public String getClient_secret() {
        return client_secret;
    }

    public void setClient_secret(String client_secret) {
        this.client_secret = client_secret;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "oauth/token";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }
}
