package com.libawall.api.oauth.request;


import com.libawall.api.oauth.response.CheckToken;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 校验客户端token
 */
public class CheckTokenRequest implements SdkRequest<CheckToken> {
    private String token;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "oauth/check_token";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
