package com.libawall.api.login.request;


import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;
import org.apache.commons.lang3.StringUtils;

/**
 * 用户退出
 */
public class LogoutRequest implements SdkRequest<BaseResponse<Void>> {
    /**
     * 用户id
     */
    private final transient String token;

    private  transient String clientId;

    public LogoutRequest(String token){
        this.token=token;
    }

    public LogoutRequest(String token,String clientId){
        this.token=token;
        this.clientId=clientId;
    }
    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/logout";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
