package com.libawall.api.login.request;


import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * 用户登陆
 */
public class LoginRequest implements SdkRequest<BaseResponse<Map<String,Object>>> {
    /**
     * 用户id
     */
    private final transient Long staffId;
    private transient String clientId;

    public LoginRequest(Long staffId){
        this.staffId=staffId;
    }

    public LoginRequest(Long staffId,String clientId){
        this.staffId=staffId;
        this.clientId=clientId;
    }
    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/login";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
