package com.libawall.api.file.request;


import com.libawall.api.file.response.FileUserRelResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

public class FileDetailsRequest implements SdkRequest<BaseResponse<FileUserRelResponse>> {

    private final transient Long id;

    public FileDetailsRequest(Long id){
        this.id=id;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "file/"+id;
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
