package com.libawall.api.enums;
/**
 *企业系统参数开关
 **/
public enum EnterpriseViceEnum {
    ON(1, "开"),
    OFF(2, "关")
    ;

    private Integer code;
    private String desc;

    public static EnterpriseViceEnum getInstance(Integer code) {
        if (code == null){ return null;}
        for (EnterpriseViceEnum  statusEnum: EnterpriseViceEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }

    EnterpriseViceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
