package com.libawall.api.enums;

/**
 * 外带用印类型
 */
public enum DocumentTakeoutEnum {
    NOT_TAKEOUT_EXAMINE(1,"本部使用"),
    HAVE_TAKEOUT_EXAMINE(2,"外带使用")
    ;

    private final Integer code;

    private final String desc;

    DocumentTakeoutEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DocumentTakeoutEnum getInstance(Integer code) {
        if (code == null){ return null;}
        for (DocumentTakeoutEnum statusEnum: DocumentTakeoutEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
