package com.libawall.api.enums;

/**
 * 用印类型
 */
public enum DocumentRemoteTypeStateEnum {
    NOT_TAKEOUT_EXAMINE(1,"常规用印"),
    HAVE_TAKEOUT_EXAMINE(2,"远程用印"),
    CONTINUOUS_EXAMINE(3,"连续用印")
    ;

    private final Integer code;

    private final String desc;

    DocumentRemoteTypeStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DocumentRemoteTypeStateEnum getInstance(Integer code) {
        if (code == null){ return null;}
        for (DocumentRemoteTypeStateEnum statusEnum: DocumentRemoteTypeStateEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }

    public static Boolean isSpecialSeal(Integer code) {
        return DocumentRemoteTypeStateEnum.HAVE_TAKEOUT_EXAMINE.getCode().equals(code) ||
                DocumentRemoteTypeStateEnum.CONTINUOUS_EXAMINE.getCode().equals(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
