package com.libawall.api.enums;


import java.util.Arrays;

/**
 * 附件二维码-支持文件
 */
public enum DocumentFileSuffixEnum{

   /* JPG(1, "图片","JPG"),
    JPEG(2, "图片","JPEG"),
    PNG(3, "图片","PNG"),*/
    DOC(4, "文档","DOC"),
    DOCX(5, "文档","DOCX"),
   /* XLS(6, "文档","XLS"),
    XLSX(7, "文档","XLSX"),
    PPT(8, "文档","PPT"),
    PPTX(9, "文档","PPTX"),*/
    PDF(10, "文档","PDF"),
    ;

    private final Integer code;
    private final String desc;
    private final String suffix;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getSuffix() {
        return suffix;
    }

    DocumentFileSuffixEnum(Integer code, String desc, String suffix) {
        this.code = code;
        this.desc = desc;
        this.suffix = suffix;
    }

    public static DocumentFileSuffixEnum getInstance(Integer code) {
        return Arrays.stream(DocumentFileSuffixEnum.values()).filter(item -> item.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }

    public static DocumentFileSuffixEnum getInstanceSuffix(String suffix) {
        return Arrays.stream(DocumentFileSuffixEnum.values()).filter(item -> item.getSuffix().equalsIgnoreCase(suffix))
                .findFirst()
                .orElse(null);
    }
}
