package com.libawall.api.enums;

import java.util.Arrays;

/**
 * 附件二维码-大小
 */
public enum DocumentFileQrcodeSizeEnum{

    Size_2020_MM(1, "20*20",20*7.42),
    Size_2525_MM(2, "25*25",25*7.42),
    Size_3030_MM(3, "30*30",30*7.42),
    Size_3535_MM(4, "35*35",35*7.42),
    ;

    private final Integer code;
    private final String desc;
    private final double size;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public double getSize() {
        return size;
    }

    DocumentFileQrcodeSizeEnum(Integer code, String desc, double size) {
        this.code = code;
        this.desc = desc;
        this.size = size;
    }

    public static DocumentFileQrcodeSizeEnum getInstance(Integer code) {
        return Arrays.stream(DocumentFileQrcodeSizeEnum.values()).filter(item -> item.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }
}
