package com.libawall.api.enums;

import java.util.Arrays;

/**
 * 附件二维码
 */
public enum DocumentFileQrcodeEnum{

    UPPER_LEFT(1, "左上"),
    UPPER_RIGHT(2, " 右上"),
    LOWER_LEFT(3, "左下"),
    LOWER_RIGHT(4, "右下"),
    ;

    private final Integer code;
    private final String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    DocumentFileQrcodeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DocumentFileQrcodeEnum getInstance(Integer code) {
        return Arrays.stream(DocumentFileQrcodeEnum.values()).filter(item -> item.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }
}
