package com.libawall.api.enums;

public enum DocumentFaceImageTypeEnum{

    COMMON(1,"用印人脸"),
    MAKE_UP(2,"补拍人脸"),
    COVER_FILE(3,"补盖人脸"),

    ;

    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DocumentFaceImageTypeEnum getInstance(Integer code) {
        if (code == null){ return null;}
        for (DocumentFaceImageTypeEnum statusEnum: DocumentFaceImageTypeEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }


    DocumentFaceImageTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
