package com.libawall.api.document.response;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 普通用印文件详情查看
 * yda_document
 * @author
 */
public class DocumentDetailsResponse {

    /**
     * 文件名字
     */
    private String fileName;

    /**
     * 申请人姓名
     */
    private String staffName;

    /**
     * 申请人id
     */
    private Long staffId;

    /**
     * 用户头像
     */
    private Long avatarId;

    /**
     * 用户头像地址
     */
    private String fullAvatar;


    /**
     * 1、特权用户用印 2、普通用印
     */
    private Integer status;


    /**
     * 印章名称和申请次数 实际用印次数
     */
    private List<DocumentSealRelResponse> sealShow;


    /**
     * 用印状态 不可用0，待用印1，用印中2，用印完成3
     */
    private Integer sealStatus;

    /**
     * 审批状态 用印审批中0，用印同意1，用印拒绝2
     */
    private Integer examineStatus;

    /**
     * 申请事由
     */
    private String applyText;

    /**
     * 申请用印附件 链接以及后缀
     */
    private List<DocumentApplyFileDetailsResponse> documentApplyFileS;

    /**
     * 创建时间
     */
    private LocalDateTime applyTime;


    /**
     * 是否有外带审批人
     * 1、无外带审批人（常规用印） 2、有外带审批人（远程用印） 3、连续用印
     */
    private Integer remote;

    /**
     * 1、没有开启ocr 2、开启ocr
     */
    private Integer remoteOcr;

    /**
     * 1、本部使用 2、外带
     */
    private Integer takeout;

    /**
     * 远程确认人id
     */
    private Long remoteStaffId;

    /**
     * 远程确认人姓名
     */
    private String remoteStaffName;

    /**
     * 远程确认人用户头像
     */
    private Long remoteAvatarId;

    /**
     * 远程用印用户头像地址
     */
    private String fullRemoteAvatar;

    /**
     * 多外带地点集合
     */
    private List<DocumentApplyAddressResponse> takeAwayInfos;

    /**
     * 外带地点起始时间
     */
    private LocalDateTime startTime;

    /**
     * 外带地点终止时间
     */
    private LocalDateTime finishTime;

    /**
     * 远程审批附件(图片)
     */
    private List<DocumentRemoteViceResponse> documentRemoteVice;

    /**
     * 远程审批附件(视频)
     */
    private List<DocumentRemoteViceResponse> documentRemoteVideoList;


    /**
     * 二维码水印大小1、20*20,2、25*25,3、30*30,4、35*35
     * {@link com.libawall.api.enums.DocumentFileQrcodeSizeEnum}
     */
    private Integer qrcodeSize;

    /**
     * 二维码水印位置 1左上、2右上、3左下、4右下
     * {@link com.libawall.api.enums.DocumentFileQrcodeEnum}
     */
    private Integer qrcodePositionType;


    /**
     * 二维码水印 1、开启  2、关闭
     * {@link com.libawall.api.enums.EnterpriseViceEnum}
     */
    private Integer qrcodeType;

    /**
     * 二维码渲染类型 1、单文件  2、单页
     * {@link com.libawall.api.enums.DocumentFileQrcodePageTypeEnum}
     */
    private Integer qrcodePageType;


    /**
     * 章筒拍摄视频 1、开启  2、关闭
     * {@link com.libawall.api.enums.EnterpriseViceEnum}
     */
    private Integer equipmentRec;


    /**
     * 录视频  1、开启 2、关闭
     */
    private Integer videoType;

    /**
     * 印章识别 1、开启 2、关闭
     */
    private Integer sealDiscern;


    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public Long getAvatarId() {
        return avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    public String getFullAvatar() {
        return fullAvatar;
    }

    public void setFullAvatar(String fullAvatar) {
        this.fullAvatar = fullAvatar;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<DocumentSealRelResponse> getSealShow() {
        return sealShow;
    }

    public void setSealShow(List<DocumentSealRelResponse> sealShow) {
        this.sealShow = sealShow;
    }

    public Integer getSealStatus() {
        return sealStatus;
    }

    public void setSealStatus(Integer sealStatus) {
        this.sealStatus = sealStatus;
    }

    public Integer getExamineStatus() {
        return examineStatus;
    }

    public void setExamineStatus(Integer examineStatus) {
        this.examineStatus = examineStatus;
    }

    public String getApplyText() {
        return applyText;
    }

    public void setApplyText(String applyText) {
        this.applyText = applyText;
    }

    public List<DocumentApplyFileDetailsResponse> getDocumentApplyFileS() {
        return documentApplyFileS;
    }

    public void setDocumentApplyFileS(List<DocumentApplyFileDetailsResponse> documentApplyFileS) {
        this.documentApplyFileS = documentApplyFileS;
    }

    public LocalDateTime getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(LocalDateTime applyTime) {
        this.applyTime = applyTime;
    }

    public Integer getRemote() {
        return remote;
    }

    public void setRemote(Integer remote) {
        this.remote = remote;
    }

    public Integer getRemoteOcr() {
        return remoteOcr;
    }

    public void setRemoteOcr(Integer remoteOcr) {
        this.remoteOcr = remoteOcr;
    }

    public Integer getTakeout() {
        return takeout;
    }

    public void setTakeout(Integer takeout) {
        this.takeout = takeout;
    }

    public Long getRemoteStaffId() {
        return remoteStaffId;
    }

    public void setRemoteStaffId(Long remoteStaffId) {
        this.remoteStaffId = remoteStaffId;
    }

    public String getRemoteStaffName() {
        return remoteStaffName;
    }

    public void setRemoteStaffName(String remoteStaffName) {
        this.remoteStaffName = remoteStaffName;
    }

    public Long getRemoteAvatarId() {
        return remoteAvatarId;
    }

    public void setRemoteAvatarId(Long remoteAvatarId) {
        this.remoteAvatarId = remoteAvatarId;
    }

    public String getFullRemoteAvatar() {
        return fullRemoteAvatar;
    }

    public void setFullRemoteAvatar(String fullRemoteAvatar) {
        this.fullRemoteAvatar = fullRemoteAvatar;
    }

    public List<DocumentApplyAddressResponse> getTakeAwayInfos() {
        return takeAwayInfos;
    }

    public void setTakeAwayInfos(List<DocumentApplyAddressResponse> takeAwayInfos) {
        this.takeAwayInfos = takeAwayInfos;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
    }

    public List<DocumentRemoteViceResponse> getDocumentRemoteVice() {
        return documentRemoteVice;
    }

    public void setDocumentRemoteVice(List<DocumentRemoteViceResponse> documentRemoteVice) {
        this.documentRemoteVice = documentRemoteVice;
    }

    public List<DocumentRemoteViceResponse> getDocumentRemoteVideoList() {
        return documentRemoteVideoList;
    }

    public void setDocumentRemoteVideoList(List<DocumentRemoteViceResponse> documentRemoteVideoList) {
        this.documentRemoteVideoList = documentRemoteVideoList;
    }

    public Integer getQrcodeSize() {
        return qrcodeSize;
    }

    public void setQrcodeSize(Integer qrcodeSize) {
        this.qrcodeSize = qrcodeSize;
    }

    public Integer getQrcodePositionType() {
        return qrcodePositionType;
    }

    public void setQrcodePositionType(Integer qrcodePositionType) {
        this.qrcodePositionType = qrcodePositionType;
    }

    public Integer getQrcodeType() {
        return qrcodeType;
    }

    public void setQrcodeType(Integer qrcodeType) {
        this.qrcodeType = qrcodeType;
    }

    public Integer getQrcodePageType() {
        return qrcodePageType;
    }

    public void setQrcodePageType(Integer qrcodePageType) {
        this.qrcodePageType = qrcodePageType;
    }

    public Integer getEquipmentRec() {
        return equipmentRec;
    }

    public void setEquipmentRec(Integer equipmentRec) {
        this.equipmentRec = equipmentRec;
    }

    public Integer getVideoType() {
        return videoType;
    }

    public void setVideoType(Integer videoType) {
        this.videoType = videoType;
    }

    public Integer getSealDiscern() {
        return sealDiscern;
    }

    public void setSealDiscern(Integer sealDiscern) {
        this.sealDiscern = sealDiscern;
    }
}
