package com.libawall.api.document.response;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 待用印列表
 */
public class DocumentAwaitResponse implements Serializable {
    /**
     * 文件id
     */
    private Long documentId;
    /**
     * 文件名字
     */
    private String fileName;

    /**
     * 用户id
     */
    private Long staffId;

    /**
     * 申请人姓名
     */
    private String staffName;

    /**
     * 业务流程名称
     */
    private String processName;

    /**
     * 1、特权用户用印 2、普通用印 3、电子签章
     */
    private Integer status;

    /**
     * 申请时间
     */
    private LocalDateTime applyTime;

    /**
     * 审批状态 用印审批中0，用印同意1，用印拒绝2，归档审批中3，归档审批通过4，归档审批未通过5
     */
    private Integer examineStatus;

    /**
     * 用印状态 不可用0，待用印1，用印中2，用印完成|待归档 3，已归档4
     */
    private Integer sealStatus;

    /**
     * 1、无外带审批人（常规用印） 2、有外带审批人（远程用印） 3、连续用印
     */
    private Integer remote;

    /**
     * 申请编码
     */
    private String applicationCode;


    /**
     * 排序字段
     */
    private Integer sortIndex;

    /**
     * 1、没有开启ocr 2、开启ocr
     */
    private Integer remoteOcr;

    /**
     * 开始用印
     */
    private Boolean startSeals;

    /**
     * 印章综合
     */
    private List<DocumentAwaitSealRelResponse> documentSealRelVOS;

    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public String getProcessName() {
        return processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public LocalDateTime getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(LocalDateTime applyTime) {
        this.applyTime = applyTime;
    }

    public Integer getExamineStatus() {
        return examineStatus;
    }

    public void setExamineStatus(Integer examineStatus) {
        this.examineStatus = examineStatus;
    }

    public Integer getSealStatus() {
        return sealStatus;
    }

    public void setSealStatus(Integer sealStatus) {
        this.sealStatus = sealStatus;
    }

    public Integer getRemote() {
        return remote;
    }

    public void setRemote(Integer remote) {
        this.remote = remote;
    }

    public String getApplicationCode() {
        return applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public Integer getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(Integer sortIndex) {
        this.sortIndex = sortIndex;
    }

    public Integer getRemoteOcr() {
        return remoteOcr;
    }

    public void setRemoteOcr(Integer remoteOcr) {
        this.remoteOcr = remoteOcr;
    }

    public Boolean getStartSeals() {
        return startSeals;
    }

    public void setStartSeals(Boolean startSeals) {
        this.startSeals = startSeals;
    }

    public List<DocumentAwaitSealRelResponse> getDocumentSealRelVOS() {
        return documentSealRelVOS;
    }

    public void setDocumentSealRelVOS(List<DocumentAwaitSealRelResponse> documentSealRelVOS) {
        this.documentSealRelVOS = documentSealRelVOS;
    }
}
