package com.libawall.api.document.request;


import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.document.response.DocumentRemoteDetailsResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

/**
 * 获取远程审批详情
 */
public class DocumentRemoteViceDetailsRequest implements JsonSdkRequest<BaseResponse<DocumentRemoteDetailsResponse>> {
    /**
     * 消息id
     */
    private final transient Long businessId;

    public DocumentRemoteViceDetailsRequest(Long businessId){
        this.businessId=businessId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/examine/remote/details?businessId="+businessId;
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
