package com.libawall.api.document.request;


import com.libawall.api.document.response.DocumentAwaitResponse;
import com.libawall.api.util.PageResponse;
import com.libawall.api.util.PaginationQuery;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;


/**
 * 待用印页面展示
 */
public class DocumentPrintedQueryRequest extends PaginationQuery implements SdkRequest<PageResponse<DocumentAwaitResponse>> {

    /**
     * 用户id
     */
    private Long staffId;

    /**
     * 文件名字 模糊查询
     */
    private String searchFileName;

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public String getSearchFileName() {
        return searchFileName;
    }

    public void setSearchFileName(String searchFileName) {
        this.searchFileName = searchFileName;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/document/stay/show";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
