package com.libawall.api.document.request;


import com.libawall.api.document.response.DocumentFileDetailsResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;


/**
 * 根据用印文件id获取文件地址
 */
public class DocumentFileDetailsRequest implements SdkRequest<BaseResponse<DocumentFileDetailsResponse>> {

    /**
     * 文件id
     */
    private final transient Long documentFileId;

    public DocumentFileDetailsRequest(Long documentFileId) {
        this.documentFileId = documentFileId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/documentFile/details/"+ documentFileId;
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.GET;
    }
}
