package com.libawall.api.document.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * SDK 补盖申请
 */
public class DocumentApplyReplenishSealRequest implements JsonSdkRequest<BaseResponse<Boolean>> {
    /**
     * 文件申请表id
     */
    private Long documentId;

    /**
     * 文件对应印章id
     */
    private Long sealId;

    /**
     * 申请人id
     */
    private Long staffId;


    /**
     * 补盖理由 1、盖错位置  2、盖印不清晰  3、盖印中断 4、申请数量不够 5、其他
     */
    private Integer reReason;

    /**
     * 补盖申请补充事由
     */
    private String reText;

    /**
     * 申请补盖次数
     */
    private Long reApplicationNumber;

    /**
     * 补盖申请附件 连接file id
     */
    private List<Long> fileIds;


    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public Long getSealId() {
        return sealId;
    }

    public void setSealId(Long sealId) {
        this.sealId = sealId;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public Integer getReReason() {
        return reReason;
    }

    public void setReReason(Integer reReason) {
        this.reReason = reReason;
    }

    public String getReText() {
        return reText;
    }

    public void setReText(String reText) {
        this.reText = reText;
    }

    public Long getReApplicationNumber() {
        return reApplicationNumber;
    }

    public void setReApplicationNumber(Long reApplicationNumber) {
        this.reApplicationNumber = reApplicationNumber;
    }

    public List<Long> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<Long> fileIds) {
        this.fileIds = fileIds;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/replenish/seal";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }
}
