package com.libawall.api.document.request;

import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.util.List;

/**
 * SDK 补盖 结束用印状态上传
 */
public class DocumentApplyReplenishOverRequest implements JsonSdkRequest<BaseResponse<Boolean>> {
    /**
     * 文件申请表id
     */
    private Long documentId;

    /**
     * 文件对应印章id
     */
    private List<Long> sealIdList;

    /**
     * 申请人id
     */
    private Long staffId;


    public Long getDocumentId() {
        return documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public List<Long> getSealIdList() {
        return sealIdList;
    }

    public void setSealIdList(List<Long> sealIdList) {
        this.sealIdList = sealIdList;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/replenish/over";
    }

    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.PUT;
    }
}
