package com.libawall.api.document.request;

import com.libawall.api.document.request.dto.DocumentApplyAddressRequest;
import com.libawall.api.util.JsonSdkRequest;

import com.libawall.api.document.request.dto.ThirdDocumentApplyFileAddDTO;
import com.libawall.api.document.request.dto.ThirdDocumentSealRelAddDTO;
import com.libawall.api.document.response.DocumentIdResponse;
import com.libawall.api.util.BaseResponse;
import com.libawall.api.util.SdkRequest;
import com.libawall.util.httpclient.RequestMethod;

import java.math.BigDecimal;
import java.util.List;

/**
 * SDK 普通用印添加申请文件
 */
public class DocumentApplyAddRequest implements JsonSdkRequest<BaseResponse<DocumentIdResponse>> {
    /**
     * 申请人id
     */
    private Long staffId;

    /**
     * 文件名字
     */
    private String fileName;

    /**
     * 印章名称和次数
     */
    private List<ThirdDocumentSealRelAddDTO> sealShowDTO;

    /**
     * 申请事由
     */
    private String applyText;

    /**
     * 申请用印附件 连接file id
     */
    private List<ThirdDocumentApplyFileAddDTO> documentApplyFile;

    /**
     * 是否选择外带  1、本部使用 2、外带使用
     */
    private Integer takeout;

    /**
     * 外带开始时间
     */
    private String startTime;

    /**
     * 外带结束时间
     */
    private String finishTime;

    /**
     * 外带地点集合
     */
    private List<DocumentApplyAddressRequest> takeAwayInfos;

    /**
     * 1、无外带审批人（常规用印） 2、有外带审批人（远程用印） 3、连续用印
     */
    private Integer remote;

    /**
     * 远程盖印确认人
     */
    private Long remoteStaffId;

    /**
     * 业务流程id
     */
    private Long processId;

    /**
     * ocr开关状态，1、关闭；2、开启
     */
    private Integer remoteOcr;

    /**
     * 用印策略：1、不通过不可盖印；2、比对不同过可以盖印
     */
    private Integer ocrStrategy;

    /**
     * 匹配率 0-100的整数，比对小于指定匹配率满足条件后将发送预警推送
     */
    private Integer ocrDegree;

    /**
     * ocr推送人员集合
     */
    private List<Long> ocrPushStaffIds;

    /**
     * 录视频  1、开启 2、关闭
     */
    private Integer videoType;

    /**
     * 印章识别 1、开启 2、关闭
     */
    private Integer sealDiscern;

    /**
     * 用印前拍照 1开启 2关闭
     */
    private Integer beforeSealPhoto;


    /**
     * 用印后自动抓拍 1开启 2关闭
     */
    private Integer afterSealSnap;

    /**
     * 自动抓拍间隔 0.5 1.0 1.5 2.0
     */
    private BigDecimal snapInterval;

    /**
     * 超时预警发送状态，默认0未发送，1超时前已发送，2超时后已发送，12超时前后都已发送
     */
    private Integer warnSend;

    /**
     * 指纹快捷用印 1、开启  2、关闭
     */
    private Integer fastSeal;

    /**
     * 盖印需要盖印人指纹认证 1、开启 2、关闭
     */
    private Integer authentication;

    /**
     * 用印地点限制 1开启 2关闭
     */
    private Integer locationLimit;

    /**
     * 用印时间限制(总开关) 1、开启 2、关闭
     */
    private Integer usageTime;

    /**
     * 审批后x天完成用印，超时无法使用
     */
    private Integer printTime;

    /**
     * 盖印后x小时完成用印，超时无法使用
     */
    private Integer stampingTime;

    /**
     * 二维码水印大小1、20*20,2、25*25,3、30*30,4、35*35
     * {@link com.libawall.api.enums.DocumentFileQrcodeSizeEnum}
     */
    private Integer qrcodeSize;

    /**
     * 二维码水印位置 1左上、2右上、3左下、4右下
     * {@link com.libawall.api.enums.DocumentFileQrcodeEnum}
     */
    private Integer qrcodePositionType;


    /**
     * 二维码水印 1、开启  2、关闭
     * {@link com.libawall.api.enums.EnterpriseViceEnum}
     */
    private Integer qrcodeType;

    /**
     * 二维码渲染类型 1、单文件  2、单页
     * {@link com.libawall.api.enums.DocumentFileQrcodePageTypeEnum}
     */
    private Integer qrcodePageType;


    /**
     * 章筒拍摄视频 1、开启  2、关闭
     * {@link com.libawall.api.enums.EnterpriseViceEnum}
     */
    private Integer equipmentRec;

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<ThirdDocumentSealRelAddDTO> getSealShowDTO() {
        return sealShowDTO;
    }

    public void setSealShowDTO(List<ThirdDocumentSealRelAddDTO> sealShowDTO) {
        this.sealShowDTO = sealShowDTO;
    }

    public String getApplyText() {
        return applyText;
    }

    public void setApplyText(String applyText) {
        this.applyText = applyText;
    }

    public List<ThirdDocumentApplyFileAddDTO> getDocumentApplyFile() {
        return documentApplyFile;
    }

    public void setDocumentApplyFile(List<ThirdDocumentApplyFileAddDTO> documentApplyFile) {
        this.documentApplyFile = documentApplyFile;
    }

    public Integer getTakeout() {
        return takeout;
    }

    public void setTakeout(Integer takeout) {
        this.takeout = takeout;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public List<DocumentApplyAddressRequest> getTakeAwayInfos() {
        return takeAwayInfos;
    }

    public void setTakeAwayInfos(List<DocumentApplyAddressRequest> takeAwayInfos) {
        this.takeAwayInfos = takeAwayInfos;
    }

    public Integer getRemote() {
        return remote;
    }

    public void setRemote(Integer remote) {
        this.remote = remote;
    }

    public Long getRemoteStaffId() {
        return remoteStaffId;
    }

    public void setRemoteStaffId(Long remoteStaffId) {
        this.remoteStaffId = remoteStaffId;
    }


    public Long getProcessId() {
        return processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public Integer getRemoteOcr() {
        return remoteOcr;
    }

    public void setRemoteOcr(Integer remoteOcr) {
        this.remoteOcr = remoteOcr;
    }

    public Integer getOcrStrategy() {
        return ocrStrategy;
    }

    public void setOcrStrategy(Integer ocrStrategy) {
        this.ocrStrategy = ocrStrategy;
    }

    public Integer getOcrDegree() {
        return ocrDegree;
    }

    public void setOcrDegree(Integer ocrDegree) {
        this.ocrDegree = ocrDegree;
    }

    public List<Long> getOcrPushStaffIds() {
        return ocrPushStaffIds;
    }

    public void setOcrPushStaffIds(List<Long> ocrPushStaffIds) {
        this.ocrPushStaffIds = ocrPushStaffIds;
    }

    public Integer getVideoType() {
        return videoType;
    }

    public void setVideoType(Integer videoType) {
        this.videoType = videoType;
    }

    public Integer getSealDiscern() {
        return sealDiscern;
    }

    public void setSealDiscern(Integer sealDiscern) {
        this.sealDiscern = sealDiscern;
    }

    public Integer getBeforeSealPhoto() {
        return beforeSealPhoto;
    }

    public void setBeforeSealPhoto(Integer beforeSealPhoto) {
        this.beforeSealPhoto = beforeSealPhoto;
    }

    public Integer getAfterSealSnap() {
        return afterSealSnap;
    }

    public void setAfterSealSnap(Integer afterSealSnap) {
        this.afterSealSnap = afterSealSnap;
    }

    public BigDecimal getSnapInterval() {
        return snapInterval;
    }

    public void setSnapInterval(BigDecimal snapInterval) {
        this.snapInterval = snapInterval;
    }

    public Integer getWarnSend() {
        return warnSend;
    }

    public void setWarnSend(Integer warnSend) {
        this.warnSend = warnSend;
    }

    public Integer getFastSeal() {
        return fastSeal;
    }

    public void setFastSeal(Integer fastSeal) {
        this.fastSeal = fastSeal;
    }

    public Integer getAuthentication() {
        return authentication;
    }

    public void setAuthentication(Integer authentication) {
        this.authentication = authentication;
    }

    public Integer getLocationLimit() {
        return locationLimit;
    }

    public void setLocationLimit(Integer locationLimit) {
        this.locationLimit = locationLimit;
    }

    public Integer getUsageTime() {
        return usageTime;
    }

    public void setUsageTime(Integer usageTime) {
        this.usageTime = usageTime;
    }

    public Integer getPrintTime() {
        return printTime;
    }

    public void setPrintTime(Integer printTime) {
        this.printTime = printTime;
    }

    public Integer getStampingTime() {
        return stampingTime;
    }

    public void setStampingTime(Integer stampingTime) {
        this.stampingTime = stampingTime;
    }

    public Integer getQrcodeSize() {
        return qrcodeSize;
    }

    public void setQrcodeSize(Integer qrcodeSize) {
        this.qrcodeSize = qrcodeSize;
    }

    public Integer getQrcodePositionType() {
        return qrcodePositionType;
    }

    public void setQrcodePositionType(Integer qrcodePositionType) {
        this.qrcodePositionType = qrcodePositionType;
    }

    public Integer getQrcodeType() {
        return qrcodeType;
    }

    public void setQrcodeType(Integer qrcodeType) {
        this.qrcodeType = qrcodeType;
    }

    public Integer getQrcodePageType() {
        return qrcodePageType;
    }

    public void setQrcodePageType(Integer qrcodePageType) {
        this.qrcodePageType = qrcodePageType;
    }

    public Integer getEquipmentRec() {
        return equipmentRec;
    }

    public void setEquipmentRec(Integer equipmentRec) {
        this.equipmentRec = equipmentRec;
    }

    /**
     * 请求路径
     */
    @Override
    public String getUrl() {
        return "api/document/apply";
    }


    /**
     * 请求方式
     */
    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }
}
