/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.vc.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.vc.v1.model.DownloadExportReq;
import com.lark.oapi.service.vc.v1.model.DownloadExportResp;
import com.lark.oapi.service.vc.v1.model.GetExportReq;
import com.lark.oapi.service.vc.v1.model.GetExportResp;
import com.lark.oapi.service.vc.v1.model.MeetingListExportReq;
import com.lark.oapi.service.vc.v1.model.MeetingListExportResp;
import com.lark.oapi.service.vc.v1.model.ParticipantListExportReq;
import com.lark.oapi.service.vc.v1.model.ParticipantListExportResp;
import com.lark.oapi.service.vc.v1.model.ParticipantQualityListExportReq;
import com.lark.oapi.service.vc.v1.model.ParticipantQualityListExportResp;
import com.lark.oapi.service.vc.v1.model.ResourceReservationListExportReq;
import com.lark.oapi.service.vc.v1.model.ResourceReservationListExportResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export {
    private static final Logger log = LoggerFactory.getLogger(Export.class);
    private final Config config;

    public Export(Config config) {
        this.config = config;
    }

    public DownloadExportResp download(DownloadExportReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/vc/v1/exports/download", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        if (httpResponse.getStatusCode() == 200) {
            DownloadExportResp resp = new DownloadExportResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        DownloadExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadExportResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/download", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public DownloadExportResp download(DownloadExportReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/vc/v1/exports/download", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        if (httpResponse.getStatusCode() == 200) {
            DownloadExportResp resp = new DownloadExportResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        DownloadExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DownloadExportResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/download", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetExportResp get(GetExportReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        GetExportResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/vc/v1/exports/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), GetExportResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/:task_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetExportResp get(GetExportReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/vc/v1/exports/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        GetExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetExportResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/:task_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public MeetingListExportResp meetingList(MeetingListExportReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        MeetingListExportResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/meeting_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), MeetingListExportResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/meeting_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public MeetingListExportResp meetingList(MeetingListExportReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/meeting_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        MeetingListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MeetingListExportResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/meeting_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ParticipantListExportResp participantList(ParticipantListExportReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        ParticipantListExportResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/participant_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), ParticipantListExportResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/participant_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ParticipantListExportResp participantList(ParticipantListExportReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/participant_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        ParticipantListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ParticipantListExportResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/participant_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ParticipantQualityListExportResp participantQualityList(ParticipantQualityListExportReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        ParticipantQualityListExportResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/participant_quality_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), ParticipantQualityListExportResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/participant_quality_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ParticipantQualityListExportResp participantQualityList(ParticipantQualityListExportReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/participant_quality_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        ParticipantQualityListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ParticipantQualityListExportResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/participant_quality_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ResourceReservationListExportResp resourceReservationList(ResourceReservationListExportReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        ResourceReservationListExportResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/resource_reservation_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), ResourceReservationListExportResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/resource_reservation_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ResourceReservationListExportResp resourceReservationList(ResourceReservationListExportReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/vc/v1/exports/resource_reservation_list", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        ResourceReservationListExportResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ResourceReservationListExportResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/vc/v1/exports/resource_reservation_list", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

