/*
 * Decompiled with CFR 0.152.
 */
package com.justtoplay.xxl.job.plus.prop;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="xxl.job.plus")
public class XxlJobPlusProperties {
    public static final String PREFIX = "xxl.job.plus";
    private AdminProperties admin = new AdminProperties();
    private ExecutorProperties executor = new ExecutorProperties();
    @JsonIgnore
    @Autowired
    private Environment environment;

    @PostConstruct
    public void init() {
        if (!StringUtils.hasLength((String)this.getExecutor().getServiceName())) {
            String serviceName = this.environment.resolvePlaceholders("${xxl.job.plus.executor.serviceName:}");
            if (!StringUtils.hasLength((String)serviceName)) {
                serviceName = this.environment.resolvePlaceholders("${spring.application.name}");
            }
            this.getExecutor().setServiceName(serviceName);
        }
    }

    public AdminProperties getAdmin() {
        return this.admin;
    }

    public void setAdmin(AdminProperties admin) {
        this.admin = admin;
    }

    public ExecutorProperties getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorProperties executor) {
        this.executor = executor;
    }

    public static class ExecutorProperties {
        private String serviceName;
        private String logPath = "./logs/xxl-job/jobhandler";
        private Integer logRetentionDays = 30;

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getLogPath() {
            return this.logPath;
        }

        public void setLogPath(String logPath) {
            this.logPath = logPath;
        }

        public Integer getLogRetentionDays() {
            return this.logRetentionDays;
        }

        public void setLogRetentionDays(Integer logRetentionDays) {
            this.logRetentionDays = logRetentionDays;
        }
    }

    public static class AdminProperties {
        private String serviceName = "xxl-job-admin";
        private String contextPath = "/xxl-job-admin";
        private String accessToken = "default_token";

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }
    }
}

