/*
 * Decompiled with CFR 0.152.
 */
package com.justtoplay.xxl.job.plus.executor;

import com.justtoplay.xxl.job.plus.discovery.DiscoveryProvider;
import com.justtoplay.xxl.job.plus.prop.XxlJobPlusProperties;
import com.justtoplay.xxl.job.plus.util.SpringContextUtil;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import com.xxl.job.core.glue.GlueFactory;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.thread.ExecutorRegistryThread;
import com.xxl.job.core.thread.JobLogFileCleanThread;
import com.xxl.job.core.thread.JobThread;
import com.xxl.job.core.thread.TriggerCallbackThread;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class XxlJobPlusSpringExecutor
extends XxlJobSpringExecutor {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobPlusSpringExecutor.class);
    private final XxlJobPlusProperties xxlJobPlusProperties;
    private final DiscoveryProvider discoveryProvider;
    private boolean isRunning = false;

    public XxlJobPlusSpringExecutor(XxlJobPlusProperties xxlJobPlusProperties, DiscoveryProvider discoveryProvider) {
        this.xxlJobPlusProperties = xxlJobPlusProperties;
        this.discoveryProvider = discoveryProvider;
        discoveryProvider.listenCurrentServiceStatus();
        discoveryProvider.listenServiceStatus(xxlJobPlusProperties.getAdmin().getServiceName());
    }

    public void afterSingletonsInstantiated() {
    }

    public boolean getRunningStatus() {
        return this.isRunning;
    }

    public void start() {
        try {
            String adminServiceName = this.xxlJobPlusProperties.getAdmin().getServiceName();
            if (adminServiceName == null || adminServiceName.trim().length() == 0) {
                logger.warn(">>>>>>>>>>> xxl-job-plus, XxlJobPlusSpringExecutor start fail, adminServiceName is null.");
                return;
            }
            String serviceAddressList = "";
            for (String item : this.discoveryProvider.getServiceAddressList(adminServiceName)) {
                item = "http://" + item + (this.xxlJobPlusProperties.getAdmin().getContextPath().startsWith("/") ? this.xxlJobPlusProperties.getAdmin().getContextPath() : "/" + this.xxlJobPlusProperties.getAdmin().getContextPath());
                serviceAddressList = serviceAddressList + "," + item;
            }
            if (serviceAddressList.trim().length() == 0) {
                logger.warn(">>>>>>>>>>> xxl-job-plus, XxlJobPlusSpringExecutor start fail, adminAddressList is null.");
                return;
            }
            logger.info(">>>>>>>>>>> xxl-job-plus, XxlJobPlusSpringExecutor start");
            Method initJobHandlerMethodRepository = XxlJobSpringExecutor.class.getDeclaredMethod("initJobHandlerMethodRepository", ApplicationContext.class);
            initJobHandlerMethodRepository.setAccessible(true);
            initJobHandlerMethodRepository.invoke((Object)this, SpringContextUtil.getApplicationContext());
            GlueFactory.refreshInstance((int)1);
            XxlJobFileAppender.initLogPath((String)this.xxlJobPlusProperties.getExecutor().getLogPath());
            Method initAdminBizList = XxlJobExecutor.class.getDeclaredMethod("initAdminBizList", String.class, String.class);
            initAdminBizList.setAccessible(true);
            initAdminBizList.invoke((Object)this, serviceAddressList.substring(1), this.xxlJobPlusProperties.getAdmin().getAccessToken());
            Field instanceJobLogFileCleanThread = JobLogFileCleanThread.class.getDeclaredField("instance");
            instanceJobLogFileCleanThread.setAccessible(true);
            instanceJobLogFileCleanThread.set(JobLogFileCleanThread.getInstance(), new JobLogFileCleanThread());
            JobLogFileCleanThread.getInstance().start((long)this.xxlJobPlusProperties.getExecutor().getLogRetentionDays().intValue());
            Field instanceTriggerCallbackThread = TriggerCallbackThread.class.getDeclaredField("instance");
            instanceTriggerCallbackThread.setAccessible(true);
            instanceTriggerCallbackThread.set(TriggerCallbackThread.getInstance(), new TriggerCallbackThread());
            TriggerCallbackThread.getInstance().start();
            String address = "http://{ip_port}/".replace("{ip_port}", this.discoveryProvider.getCurrentServiceAddress());
            Field instanceExecutorRegistryThread = ExecutorRegistryThread.class.getDeclaredField("instance");
            instanceExecutorRegistryThread.setAccessible(true);
            instanceExecutorRegistryThread.set(ExecutorRegistryThread.getInstance(), new ExecutorRegistryThread());
            ExecutorRegistryThread.getInstance().start(this.xxlJobPlusProperties.getExecutor().getServiceName(), address);
            this.isRunning = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this.stop();
    }

    public void stop() {
        ExecutorRegistryThread.getInstance().toStop();
        if (this.getJobThreadRepository().size() > 0) {
            for (Map.Entry item : this.getJobThreadRepository().entrySet()) {
                JobThread oldJobThread = XxlJobPlusSpringExecutor.removeJobThread((int)((Integer)item.getKey()), (String)"web container destroy and kill the job.");
                if (oldJobThread == null) continue;
                try {
                    oldJobThread.join();
                }
                catch (InterruptedException e) {
                    logger.error(">>>>>>>>>>> xxl-job, JobThread destroy(join) error, jobId:{}", item.getKey(), (Object)e);
                }
            }
            this.getJobThreadRepository().clear();
        }
        this.getJobThreadRepository().clear();
        this.getJobHandlerRepository().clear();
        JobLogFileCleanThread.getInstance().toStop();
        TriggerCallbackThread.getInstance().toStop();
        this.isRunning = false;
        logger.info(">>>>>>>>>>> xxl-job-plus, XxlJobPlusSpringExecutor destroy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(List<String> adminAddressList) {
        Class<XxlJobExecutor> clazz = XxlJobExecutor.class;
        synchronized (XxlJobExecutor.class) {
            try {
                Method initAdminBizList = XxlJobExecutor.class.getDeclaredMethod("initAdminBizList", String.class, String.class);
                initAdminBizList.setAccessible(true);
                String serviceAddressList = "";
                for (String item : adminAddressList) {
                    item = "http://" + item + (this.xxlJobPlusProperties.getAdmin().getContextPath().startsWith("/") ? this.xxlJobPlusProperties.getAdmin().getContextPath() : "/" + this.xxlJobPlusProperties.getAdmin().getContextPath());
                    serviceAddressList = serviceAddressList + "," + item;
                }
                XxlJobPlusSpringExecutor.getAdminBizList().clear();
                initAdminBizList.invoke((Object)this, serviceAddressList, this.xxlJobPlusProperties.getAdmin().getAccessToken());
                logger.info(">>>>>>>>>>> xxl-job-plus, XxlJobPlusSpringExecutor refresh adminBizList");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private ConcurrentMap<Integer, JobThread> getJobThreadRepository() {
        try {
            Field jobThreadRepository = XxlJobExecutor.class.getDeclaredField("jobThreadRepository");
            jobThreadRepository.setAccessible(true);
            return (ConcurrentMap)jobThreadRepository.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return new ConcurrentHashMap<Integer, JobThread>();
        }
    }

    private ConcurrentMap<String, IJobHandler> getJobHandlerRepository() {
        try {
            Field jobHandlerRepository = XxlJobExecutor.class.getDeclaredField("jobHandlerRepository");
            jobHandlerRepository.setAccessible(true);
            return (ConcurrentMap)jobHandlerRepository.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return new ConcurrentHashMap<String, IJobHandler>();
        }
    }
}

