/*
 * Decompiled with CFR 0.152.
 */
package com.justtoplay.xxl.job.plus.config;

import com.justtoplay.xxl.job.plus.discovery.DiscoveryProvider;
import com.justtoplay.xxl.job.plus.event.DiscoveryEvent;
import com.justtoplay.xxl.job.plus.event.ServiceDownEvent;
import com.justtoplay.xxl.job.plus.event.ServiceRefreshEvent;
import com.justtoplay.xxl.job.plus.event.ServiceUpEvent;
import com.justtoplay.xxl.job.plus.executor.XxlJobPlusSpringExecutor;
import com.justtoplay.xxl.job.plus.prop.XxlJobPlusProperties;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.impl.ExecutorBizImpl;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;

@EnableConfigurationProperties(value={XxlJobPlusProperties.class})
@Configuration
public class XxlJobPlusAutoConfig
implements ApplicationListener<DiscoveryEvent> {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobPlusAutoConfig.class);
    @Resource
    private XxlJobPlusProperties xxlJobPlusProperties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private DiscoveryProvider discoveryProvider;
    private final Object lock = new Object();
    private boolean isRunning = false;

    public XxlJobPlusAutoConfig() {
        logger.info(">>>>>>>>>>> xxl-job-plus, XxlJobPlusAutoConfig init");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void onApplicationEvent(DiscoveryEvent event) {
        Object object = this.lock;
        synchronized (object) {
            XxlJobPlusSpringExecutor xxlJobExecutor = (XxlJobPlusSpringExecutor)((Object)this.applicationContext.getBean("xxlJobExecutor", XxlJobPlusSpringExecutor.class));
            if (event instanceof ServiceUpEvent) {
                if (!this.isRunning) {
                    xxlJobExecutor.start();
                }
            } else if (event instanceof ServiceDownEvent) {
                if (this.isRunning) {
                    xxlJobExecutor.stop();
                }
            } else if (event instanceof ServiceRefreshEvent) {
                ServiceRefreshEvent serviceRefreshEvent = (ServiceRefreshEvent)event;
                if (this.isRunning) {
                    if (serviceRefreshEvent.getAddressList().size() == 0) {
                        xxlJobExecutor.stop();
                    } else {
                        xxlJobExecutor.refresh(serviceRefreshEvent.getAddressList());
                    }
                } else if (serviceRefreshEvent.getAddressList().size() > 0) {
                    xxlJobExecutor.start();
                }
            }
            this.isRunning = xxlJobExecutor.getRunningStatus();
        }
    }

    @Lazy
    @Bean
    public XxlJobSpringExecutor xxlJobExecutor() {
        return new XxlJobPlusSpringExecutor(this.xxlJobPlusProperties, this.discoveryProvider);
    }

    @Lazy
    @Bean
    public ExecutorBiz executorBizImpl() {
        return new ExecutorBizImpl();
    }
}

