/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.io.IOException;
import java.util.Date;

public class DateDirective
extends Directive {
    private Expr valueExpr;
    private Expr datePatternExpr;
    private int paraNum;

    @Override
    public void setExprList(ExprList exprList) {
        this.paraNum = exprList.length();
        if (this.paraNum > 2) {
            throw new ParseException("Wrong number parameter of #date directive, two parameters allowed at most", this.location);
        }
        if (this.paraNum == 0) {
            this.valueExpr = null;
            this.datePatternExpr = null;
        } else if (this.paraNum == 1) {
            this.valueExpr = exprList.getExpr(0);
            this.datePatternExpr = null;
        } else if (this.paraNum == 2) {
            this.valueExpr = exprList.getExpr(0);
            this.datePatternExpr = exprList.getExpr(1);
        }
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (this.paraNum == 1) {
            this.outputWithoutDatePattern(env, scope, writer);
        } else if (this.paraNum == 2) {
            this.outputWithDatePattern(env, scope, writer);
        } else {
            this.outputToday(env, writer);
        }
    }

    private void outputToday(Env env, Writer writer) {
        this.write(writer, new Date(), env.getEngineConfig().getDatePattern());
    }

    private void outputWithoutDatePattern(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value != null) {
            this.write(writer, (Date)value, env.getEngineConfig().getDatePattern());
        }
    }

    private void outputWithDatePattern(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value == null) {
            return;
        }
        Object datePattern = this.datePatternExpr.eval(scope);
        if (!(datePattern instanceof String)) {
            throw new TemplateException("The sencond parameter datePattern of #date directive must be String", this.location);
        }
        this.write(writer, (Date)value, (String)datePattern);
    }

    private void write(Writer writer, Date date, String datePattern) {
        try {
            writer.write(date, datePattern);
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

