/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.sm.tomcat.ssl;

import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.res.StringManager;
import utils.crypto.sm.GmSSLProvider;
import utils.crypto.sm.tomcat.ssl.GMSSLContext;
import utils.crypto.sm.tomcat.ssl.GMTrustManager;

public class GMUtil
extends SSLUtilBase {
    public static final boolean DEBUG = false;
    private static final StringManager sm = StringManager.getManager(GMUtil.class);
    private static final Set<String> implementedProtocols;
    private static final Set<String> implementedCiphers;
    private SSLHostConfigCertificate conf = null;

    public GMUtil(SSLHostConfigCertificate certificate) {
        this(certificate, true);
    }

    public GMUtil(SSLHostConfigCertificate certificate, boolean warnOnSkip) {
        super(certificate, warnOnSkip);
        this.conf = certificate;
    }

    public KeyManager[] getKeyManagers() throws Exception {
        String keystoreFile = null;
        String keystorePass = null;
        String keystoreType = null;
        keystoreFile = this.conf.getCertificateKeystoreFile();
        keystorePass = this.conf.getCertificateKeystorePassword();
        keystoreType = this.conf.getCertificateKeystoreType();
        String ciphers = this.conf.getSSLHostConfig().getCiphers();
        KeyManager[] keyManagers = null;
        try {
            KeyStore pfx = KeyStore.getInstance(keystoreType);
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(keystoreFile);
            if (inputStream == null) {
                inputStream = Resources.asByteSource((URL)new URL(keystoreFile)).openStream();
            }
            pfx.load(inputStream, keystorePass.toCharArray());
            if (pfx != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", GmSSLProvider.GM_PROVIDER);
                keyManagerFactory.init(pfx, keystorePass.toCharArray());
                keyManagers = keyManagerFactory.getKeyManagers();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KeyManager[] kms = keyManagers;
        return kms;
    }

    public TrustManager[] getTrustManagers() throws Exception {
        TrustManager[] trustManagers = null;
        TrustManager[] tms = trustManagers = new TrustManager[]{new GMTrustManager()};
        return tms;
    }

    protected Set<String> getImplementedProtocols() {
        return implementedProtocols;
    }

    protected Set<String> getImplementedCiphers() {
        return implementedCiphers;
    }

    public String[] getEnabledProtocols() {
        String[] ss = super.getEnabledProtocols();
        String[] ss2 = new String[ss.length + 2];
        for (int i = 0; i < ss.length; ++i) {
            ss2[i] = ss[i];
        }
        ss2[ss.length] = GmSSLProvider.GMTLS;
        ss2[ss.length + 1] = "TLSv1.2";
        return ss2;
    }

    public String[] getEnabledCiphers() {
        String[] ss = super.getEnabledCiphers();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i].indexOf("ECDSA") != -1 || ss[i].indexOf("_DSS_") != -1) continue;
            v.addElement(ss[i]);
        }
        LinkedHashSet cs = this.conf.getSSLHostConfig().getCipherList();
        String cc = this.conf.getSSLHostConfig().getCiphers();
        v.addElement("SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        v.addElement("TLS_RSA_WITH_AES_128_CBC_SHA256");
        v.addElement("ECC_SM4_GCM_SM3");
        v.addElement("ECC_SM4_CBC_SM3");
        v.addElement("ECDHE_SM4_GCM_SM3");
        v.addElement("ECDHE_SM4_CBC_SM3");
        ss = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ss[i] = (String)v.elementAt(i);
        }
        return ss;
    }

    protected boolean isTls13RenegAuthAvailable() {
        return false;
    }

    public SSLContext createSSLContextInternal(List<String> negotiableProtocols) throws Exception {
        return new GMSSLContext(this.sslHostConfig.getSslProtocol());
    }

    protected Log getLog() {
        return new Log(){

            public boolean isDebugEnabled() {
                return false;
            }

            public boolean isErrorEnabled() {
                return false;
            }

            public boolean isFatalEnabled() {
                return false;
            }

            public boolean isInfoEnabled() {
                return false;
            }

            public boolean isTraceEnabled() {
                return false;
            }

            public boolean isWarnEnabled() {
                return false;
            }

            public void trace(Object message) {
            }

            public void trace(Object message, Throwable t) {
            }

            public void debug(Object message) {
            }

            public void debug(Object message, Throwable t) {
            }

            public void info(Object message) {
            }

            public void info(Object message, Throwable t) {
            }

            public void warn(Object message) {
            }

            public void warn(Object message, Throwable t) {
            }

            public void error(Object message) {
            }

            public void error(Object message, Throwable t) {
            }

            public void fatal(Object message) {
            }

            public void fatal(Object message, Throwable t) {
            }
        };
    }

    static {
        GMSSLContext context = null;
        try {
            context = new GMSSLContext(GmSSLProvider.GMTLS);
            context.init(null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        String[] implementedProtocolsArray = context.getSupportedSSLParameters().getProtocols();
        implementedProtocols = new HashSet<String>(implementedProtocolsArray.length);
        for (String protocol : implementedProtocolsArray) {
            String protocolUpper = protocol.toUpperCase(Locale.ENGLISH);
            if (!"SSLV2HELLO".equals(protocolUpper) && !"SSLV3".equals(protocolUpper) && protocolUpper.contains("SSL")) continue;
            implementedProtocols.add(protocol);
        }
        String[] implementedCipherSuiteArray = context.getSupportedSSLParameters().getCipherSuites();
        implementedCiphers = new HashSet<String>(implementedCipherSuiteArray.length);
        implementedCiphers.addAll(Arrays.asList(implementedCipherSuiteArray));
    }
}

